/*
Rdex version 2.4 for Android

Copyright (C) 2018 Peter Newman <pn@pnewman.com>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>.
*/

package com.pnewman.rdex;

import java.util.List;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;


public class SearchList extends ListActivity {

    @Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
        setContentView(R.layout.search_list);
        Intent caller = getIntent();
        String pageTitle = caller.getStringExtra(Rdex.KEY_DISPLAY_PAGE_TITLE);
        setTitle(pageTitle);
        List<String> item = caller.getStringArrayListExtra(Rdex.KEY_DISPLAY_LIST);
        if (item != null) {
            ArrayAdapter<String> cardList =
                    new ArrayAdapter<>(this, R.layout.line, item);
            setListAdapter(cardList);
        }
	}

	
    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
	    	Intent mIntent = new Intent();
	    	mIntent.putExtra(Rdex.KEY_LIST_SELECTION, position);
	    	setResult(RESULT_OK, mIntent);
	    	finish();
    }
    

    //set menu items accessed from the options menu
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.list_all_menu, menu);
        return true;
    }

    //respond to menu items selected from the menu button
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.menu_file_submenu || itemId == R.id.menu_edit_submenu ||
                itemId == R.id.menu_encryption_submenu) {
            // open submenu
            return super.onOptionsItemSelected(item);
        }

    	Intent mIntent = new Intent();
    	mIntent.putExtra(Rdex.KEY_MENU_SELECTION, item.getItemId());
    	setResult(RESULT_OK, mIntent);
    	finish();
    	return true;
    }
}
