/*
Rdex version 2.4 for Android

Copyright (C) 2018 Peter Newman <pn@pnewman.com>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>.
*/

package com.pnewman.rdex;

import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.method.ScrollingMovementMethod;
import android.view.WindowManager;
import android.widget.TextView;

public class Help extends Activity {
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	    setContentView(R.layout.help);

    	//hides soft keyboard on startup
    	getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);

    	TextView helpPane = findViewById(R.id.help);
        helpPane.setMovementMethod(new ScrollingMovementMethod());
        helpPane.setClickable(false);		//to avoid dimming on scroll
        helpPane.setLongClickable(false);	//to avoid dimming on scroll

        //set text size according to preferences
        SharedPreferences settings = getSharedPreferences("Rdex", 0);
        int sizeSetting = settings.getInt(Rdex.KEY_SETTINGS_SIZE, Preferences.DEFAULT_TEXT_SIZE);
	    if (sizeSetting < Preferences.SIZE_START_VALUE ||
	    	sizeSetting > Preferences.SIZE_ARRAY_MAX * 2 + Preferences.SIZE_START_VALUE)
	    	sizeSetting = Preferences.DEFAULT_TEXT_SIZE;
	    helpPane.setTextSize((float) sizeSetting);
        
        Intent caller = getIntent();
        setTitle(caller.getStringExtra(Rdex.KEY_DISPLAY_PAGE_TITLE));
        helpPane.setText(caller.getStringExtra(Rdex.KEY_DISPLAY_HELP_FILE));
	}
}
