/*
Rdex version 2.4 for Android

Copyright (C) 2018 Peter Newman <pn@pnewman.com>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>.
*/

package com.pnewman.rdex;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;


public class FileDialog extends ListActivity {
    private static final String root = "/";

    private static class Entry {
		String item;	// name string presented to user
		String path;	// full path of file

		public Entry(String itemStr, String pathStr) {
			item = itemStr;
			path = pathStr;
		}
	}

	private List<Entry> entries = null;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
        setContentView(R.layout.file_dialog);
        setTitle(R.string.file_dialog_title);
        // (Environment.getExternalStorageDirectory() not supported after version 29)
		File extDir = this.getExternalFilesDir(null);
		if (extDir != null) getDir(extDir.getAbsolutePath());
	}

    private void getDir(String dirPath) {
		TextView myPath = findViewById(R.id.path);
		myPath.setText(String.format(getString(R.string.file_dialog_path), dirPath));
		TextView footer = findViewById(R.id.dir_empty);
		footer.setText("");

		entries = new ArrayList<>();
        
        File f = new File(dirPath);
        File[] files = f.listFiles(new FileFilter() {
			@Override
			public boolean accept(File pathname) {
				//If a file or directory is hidden, or unreadable, don't show it in the list.
				if (pathname.isHidden())
					return false;
				return pathname.canRead();
			}
		});

        if (!dirPath.equals(root)) {
        	entries.add(new Entry("../", f.getParent()));
        }

		int numFiles = 0;
        if (files != null) {
			for (File file : files) {
				if (file.isDirectory())
					entries.add(new Entry(file.getName() + "/", file.getPath()));
				else
					entries.add(new Entry(file.getName(), file.getPath()));
				++numFiles;
			}
		}

		if (numFiles == 0)
			footer.setText(R.string.no_data);

        // Sort the files alphabetically.
		// (Sort on full pathname to avoid problem of files starting with chars before '.')
		Collections.sort(entries, new Comparator<Entry>() {
			@Override
			public int compare(Entry entry01, Entry entry02) {
				return entry01.path.compareToIgnoreCase(entry02.path);
			}
		});

		List<String> items = new ArrayList<>();
		for (Entry entry : entries)
			items.add(entry.item);

        ArrayAdapter<String> fileList =
				new ArrayAdapter<>(this, R.layout.row, items);
        setListAdapter(fileList);
    }

    
    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
     
    	File file = new File(entries.get(position).path);
     
    	if (file.isDirectory()) {
    		if(file.canRead()) {
				getDir(entries.get(position).path);
    		} else {
    			new AlertDialog.Builder(this)
    				.setIcon(R.drawable.icon)
    				.setTitle("Can't read folder: " + file.getName())
    				.setPositiveButton("OK", 
    					new DialogInterface.OnClickListener() {
							@Override
							public void onClick(DialogInterface dialog, int which) { }
    					}).show();
    		}
    	} else {
	    	Intent mIntent = new Intent();
	    	mIntent.putExtra(Rdex.KEY_FILE_NAME, file.getAbsolutePath());
	    	setResult(RESULT_OK, mIntent);
	    	finish();
    	}
    }
}
