/*
Rdex version 2.4 for Android

Copyright (C) 2018 Peter Newman <pn@pnewman.com>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>.
*/

package com.pnewman.rdex;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.View;
import android.widget.EditText;

public class EditCard extends Activity {

	private EditText mEditText;
	private boolean mCardModified;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.edit_card);
    	mEditText = findViewById(R.id.edit_card);
    	mCardModified = false;
        Intent caller = getIntent();
        String pageTitle = caller.getStringExtra(Rdex.KEY_DISPLAY_PAGE_TITLE);
        setTitle(pageTitle);
        mEditText.setTextSize(TypedValue.COMPLEX_UNIT_PX, caller.getFloatExtra(Rdex.KEY_CARD_TEXT_SIZE,
        		(float) Preferences.DEFAULT_TEXT_SIZE));
		mEditText.requestFocus();
        mEditText.setText(caller.getStringExtra(Rdex.KEY_CARD_TEXT));


        //add text watcher
        mEditText.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) { }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { } 
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            	mCardModified = true;
            } 
        }); 
	}

	
	//action for save card button
	public void saveCard(View view) {
    	Intent mIntent = new Intent();
    	mIntent.putExtra(Rdex.KEY_CARD_TEXT, mEditText.getText().toString());
    	if (mCardModified) setResult(RESULT_OK, mIntent);
    	else setResult(RESULT_CANCELED, mIntent);
    	finish();
	}

	
	//action for cancel button
	public void cancel(View view) {
    	Intent mIntent = new Intent();
    	setResult(RESULT_CANCELED, mIntent);
    	finish();
	}
}
