/*
Palm Keyring for Android

Copyright (C) 2022 Peter Newman <pn@pnewman.com>

Palm Keyring for Android is based on:
KeyringEditor v1.1
Copyright 2004 Markus Griessnig
Vienna University of Technology Institute of Computer Technology

KeyringEditor is based on:
Java Keyring v0.6
Copyright 2004 Frank Taylor <keyring@lieder.me.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>.
*/

package com.pnewman.keyring;

import java.util.List;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;
import android.widget.ArrayAdapter;
import android.widget.ListView;

public class SearchList extends ListActivity {

    @Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

        // prevent screenshot when app goes into background
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_SECURE, WindowManager.LayoutParams.FLAG_SECURE);

        setContentView(R.layout.search_list);
        Intent caller = getIntent();
        String pageTitle = caller.getStringExtra(Keyring.KEY_DISPLAY_PAGE_TITLE);
        setTitle(pageTitle);
        List<String> item = caller.getStringArrayListExtra(Keyring.KEY_DISPLAY_LIST);
        ArrayAdapter<String> cardList =
                new ArrayAdapter<>(this, R.layout.line, item);
        setListAdapter(cardList);
	}

	
    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
	    	Intent mIntent = new Intent();
	    	mIntent.putExtra(Keyring.KEY_LIST_SELECTION, position);
	    	setResult(RESULT_OK, mIntent);
	    	finish();
    }
}
