/*
Palm Keyring for Android

Copyright (C) 2022 Peter Newman <pn@pnewman.com>

Palm Keyring for Android is based on:
KeyringEditor v1.1
Copyright 2004 Markus Griessnig
Vienna University of Technology Institute of Computer Technology

KeyringEditor is based on:
Java Keyring v0.6
Copyright 2004 Frank Taylor <keyring@lieder.me.uk>

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>.
*/

// 08.01.2022 check for empty title field on new card

package com.pnewman.keyring;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;


public class EditEntry extends Activity {

	private EditText mEditTitle;
	private EditText mEditAccount;
	private EditText mEditPasswd;
	private EditText mEditNotes;
	private boolean mCardModified;
	private int mEntryId;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// prevent screenshot when app goes into background
		getWindow().setFlags(WindowManager.LayoutParams.FLAG_SECURE, WindowManager.LayoutParams.FLAG_SECURE);

		setContentView(R.layout.edit_entry);
		mEditTitle = findViewById(R.id.edit_title);
		mEditAccount = findViewById(R.id.edit_account);
		mEditPasswd = findViewById(R.id.edit_passwd);
		mEditNotes = findViewById(R.id.edit_notes);
    	mCardModified = false;
        Intent caller = getIntent();
        String pageTitle = caller.getStringExtra(Keyring.KEY_DISPLAY_PAGE_TITLE);
        setTitle(pageTitle);
        float textSize = caller.getFloatExtra(Keyring.KEY_ENTRY_TEXT_SIZE,
        		(float) Preferences.DEFAULT_TEXT_SIZE);
        mEditTitle.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
        mEditAccount.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
        mEditPasswd.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
        mEditNotes.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
        mEntryId = caller.getIntExtra(Keyring.KEY_ENTRY_ID, -1);
        mEditTitle.setText(caller.getStringExtra(Keyring.KEY_ENTRY_TITLE_TEXT));
        mEditAccount.setText(caller.getStringExtra(Keyring.KEY_ENTRY_ACCOUNT_TEXT));
        mEditPasswd.setText(caller.getStringExtra(Keyring.KEY_ENTRY_PASSWD_TEXT));
        mEditNotes.setText(caller.getStringExtra(Keyring.KEY_ENTRY_NOTES_TEXT));

        //add text watchers
        mEditTitle.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) { }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { } 
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            	mCardModified = true;
            } 
        }); 
        mEditAccount.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) { }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { } 
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            	mCardModified = true;
            } 
        });
        mEditPasswd.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) { }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { } 
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            	mCardModified = true;
            } 
        });
        mEditNotes.addTextChangedListener(new TextWatcher() {
            public void afterTextChanged(Editable s) { }
            public void beforeTextChanged(CharSequence s, int start, int count, int after) { } 
            public void onTextChanged(CharSequence s, int start, int before, int count) {
            	mCardModified = true;
            } 
        });
	}

	
	//action for save card button
	public void saveCard(View view) {
		String editTitleStr = mEditTitle.getText().toString();
		String editAccountStr = mEditAccount.getText().toString();
		String editPasswdStr = mEditPasswd.getText().toString();
		String editNotesStr = mEditNotes.getText().toString();
		int entryTextLen = editTitleStr.length() + editAccountStr.length()
					+ editPasswdStr.length() + editNotesStr.length();
		int maxTextLen = Model.MAX_ENTRY_SIZE - 256;
		if (entryTextLen > maxTextLen) {
			alertMsg("Text exceeds maximum length for an entry of " + maxTextLen + " bytes.");
			return;
		}
		if (editTitleStr == null || editTitleStr.length() == 0) {
			alertMsg("Title field cannot be empty.");
			return;
		}

    	Intent mIntent = new Intent();
    	mIntent.putExtra(Keyring.KEY_ENTRY_ID, mEntryId);
    	mIntent.putExtra(Keyring.KEY_ENTRY_TITLE_TEXT, editTitleStr);
    	mIntent.putExtra(Keyring.KEY_ENTRY_ACCOUNT_TEXT, editAccountStr);
    	mIntent.putExtra(Keyring.KEY_ENTRY_PASSWD_TEXT, editPasswdStr);
    	mIntent.putExtra(Keyring.KEY_ENTRY_NOTES_TEXT, editNotesStr);
    	if (mCardModified) setResult(RESULT_OK, mIntent);
    	else setResult(RESULT_CANCELED, mIntent);
    	finish();
	}

	
	//action for cancel button
	public void cancel(View view) {
    	Intent mIntent = new Intent();
    	setResult(RESULT_CANCELED, mIntent);
    	finish();
	}


	private void alertMsg(String msg) {
		new AlertDialog.Builder(this)
				.setMessage(msg)
				.setPositiveButton("OK",
						new DialogInterface.OnClickListener() {
							@Override
							public void onClick(DialogInterface dialog, int which) { }
						}).show();
	}
}
