/*
KeyringEditor

These programs are distributed in the hope that they will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
 */

// 11.07.2021

package com.pnewman.apps.keyring;

/**
 * Indicates the user hit the Cancel button in the password dialog
 */
public final class CancelledException extends Exception {
    private String code;

    public CancelledException(String message) {
        super(message);
        this.setCode("none");
    }
        
    public CancelledException(String code, String message) {
        super(message);
        this.setCode(code);
    }

    public CancelledException(String code, String message, Throwable cause) {
        super(message, cause);
        this.setCode(code);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
