/*
KeyringEditor

Copyright 2004 Markus Griessnig
Vienna University of Technology
Institute of Computer Technology

KeyringEditor is based on:
Java Keyring v0.6
Copyright 2004 Frank Taylor <keyring@lieder.me.uk>

These programs are distributed in the hope that they will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
*/

// EditDialog.java

// 15.11.2004

// 17.11.2004: check for empty strings

import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*; // property change stuff

/**
 * This dialog allows the user to enter a new entry.
 */
public class EditDialog extends JDialog implements ActionListener, PropertyChangeListener {
	// ----------------------------------------------------------------
	// variables
	// ----------------------------------------------------------------
	/**
	 * Variable contains saved input fields
	 *
	 * returnParameter[0] = category
	 * returnParameter[1] = title
	 * returnParameter[2] = account
	 * returnParameter[3] = password
	 * returnParameter[4] = notes
	 */
	private Object[] returnParameter;

	private JComboBox categoryList;
	private JTextField textTitle;
	private JTextField textAccount;
	private JTextField textPassword;
	private JTextArea textNotes;

	private JOptionPane optionPane;

	private String btnString1 = "OK";
	private String btnString2 = "Cancel";

	// ----------------------------------------------------------------
	// constructor
	// ----------------------------------------------------------------
	/**
	 * Default constructor generates Dialog.
	 *
	 * @param aFrame Reference to the Gui frame
	 * @param cat Vector of category-names
	 */
	public EditDialog(Frame aFrame, Vector cat) {
		super(aFrame, "New Entry", true);

		returnParameter = new Object[5];

		// list of category-names
		categoryList = new JComboBox(cat);
		categoryList.setModel(new DefaultComboBoxModel(cat));

		// text fields
		textTitle = new JTextField(40);
		textAccount = new JTextField(40);
		textPassword = new JTextField(40);
		textNotes = new JTextArea(5, 40);
		JScrollPane currentNotesScroll = new JScrollPane(textNotes);

		// labels
		String msgString1 = "Category: ";
		String msgString2 = "Title: ";
		String msgString3 = "Account: ";
		String msgString4 = "Password: ";
		String msgString5 = "Notes: ";

		Object[] array = {msgString1, categoryList,
			msgString2, textTitle,
			msgString3, textAccount,
			msgString4, textPassword,
			msgString5, currentNotesScroll};

		Object[] options = {btnString1, btnString2};

		// generate dialog
		optionPane = new JOptionPane(array,
			JOptionPane.PLAIN_MESSAGE,
			JOptionPane.YES_NO_OPTION,
			null,
			options,
			options[0]);

		setContentPane(optionPane);

		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
			/*
			 * Instead of directly closing the window,
			 * we're going to change the JOptionPane's
			 * value property.
			 */
			 optionPane.setValue(new Integer(JOptionPane.CLOSED_OPTION));
			}
		});

		addComponentListener(new ComponentAdapter() {
			public void componentShown(ComponentEvent ce) {
				textTitle.requestFocusInWindow();
			}
		});

		//Register an event handler that puts the text into the option pane.
		textTitle.addActionListener(this);

		//Register an event handler that reacts to option pane state changes.
		optionPane.addPropertyChangeListener(this);
	}

	// ----------------------------------------------------------------
	// public ---------------------------------------------------------
	// ----------------------------------------------------------------

	/**
	 * This method returns the variable returnParameter.
	 * If returnParameter[0] equals null the dialog was cancelled.
	 *
	 * @return object-array
	 */
	public Object[] getNewEntry() {
		return returnParameter;
	}

	/**
	 * This method sets OptionPane to the value of button "OK".
	 *
	 * @param e the ActionEvent to process
	 */
	public void actionPerformed(ActionEvent e) {
		optionPane.setValue(btnString1);
	}

	/**
	 * This method processes the pressed button.
	 * If button is OK account and title are checked to be not empty and variable returnParameter is set,
	 * otherwise variable returnParameter is set to null.
	 *
	 * @param e the PropertyChangeEvent to process
	 */
	 public void propertyChange(PropertyChangeEvent e) {
		String prop = e.getPropertyName();

		if (isVisible()
			&& (e.getSource() == optionPane)
			&& (JOptionPane.VALUE_PROPERTY.equals(prop) ||
				JOptionPane.INPUT_VALUE_PROPERTY.equals(prop))) {

			Object value = optionPane.getValue();

			if(value == JOptionPane.UNINITIALIZED_VALUE) {
				//ignore reset
				return;
			}

			//Reset the JOptionPane's value.
			//If you don't do this, then if the user
			//presses the same button next time, no
			//property change event will be fired.
			optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);

			if(btnString1.equals(value)) {
				// check for empty strings
				if(textTitle.getText().length() == 0) {
					JOptionPane.showMessageDialog(EditDialog.this, "Sorry, title must not be empty!\n",
                    	"Error", JOptionPane.ERROR_MESSAGE);
                    returnParameter[0] = null;
                    textTitle.requestFocusInWindow();
                    return;
                }

				if(textAccount.getText().length() == 0) {
					JOptionPane.showMessageDialog(EditDialog.this, "Sorry, account must not be empty!\n",
                    	"Error", JOptionPane.ERROR_MESSAGE);
                    returnParameter[0] = null;
                    textAccount.requestFocusInWindow();
                    return;
				}

				// ok
				setReturnParameter();
			}
			else {
				returnParameter[0] = null;
			}

			clearAndHide();
		}
	}

	// ----------------------------------------------------------------
	// private --------------------------------------------------------
	// ----------------------------------------------------------------

	/**
	 * This method hides the dialog.
	 */
	private void clearAndHide() {
		textTitle.setText(null);
		textAccount.setText(null);
		textPassword.setText(null);
		textNotes.setText(null);

		setVisible(false);
	}

	/**
	 * This method gets the input fields and updates the variable returnParameter.
	 */
	private void setReturnParameter() {
		Integer cat = new Integer(categoryList.getSelectedIndex());

		returnParameter[0] = (Object)cat;
		returnParameter[1] = (Object)textTitle.getText();
		returnParameter[2] = (Object)textAccount.getText();
		returnParameter[3] = (Object)textPassword.getText();
		returnParameter[4] = (Object)textNotes.getText();
	}
}
