/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.KeyringEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Prop {
    private static final String INI_FILENAME = "keyringeditor.ini";
    private final KeyringEditor editor;

    public Prop(KeyringEditor editor) {
        this.editor = editor;
    }

    public void setup() {
        int timeout;
        String pwTimeout;
        String csvSeparator;
        Properties props = new Properties();
        String path = "";
        try {
            path = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
            path = path != null ? path + File.separator + INI_FILENAME : INI_FILENAME;
            try (FileInputStream in = new FileInputStream(path);){
                props.load(in);
                System.err.println("Prop.java: Opened init file: " + path);
            }
        }
        catch (IOException e) {
            System.err.println("Prop.java: File " + path + " not found. Using default values.");
            return;
        }
        String titleSeparator = props.getProperty("TitleSeparator");
        if (titleSeparator != null) {
            this.editor.SEPARATOR = titleSeparator.charAt(0);
        }
        if ((csvSeparator = props.getProperty("CsvSeparator")) != null) {
            this.editor.getModel().setCsvSeparator(csvSeparator.charAt(0));
        }
        if ((pwTimeout = props.getProperty("PasswordTimeout")) != null && (timeout = Integer.parseInt(pwTimeout)) > 0 && timeout < 400) {
            KeyringEditor.PASSWORD_TIMEOUT = timeout * 60 * 1000;
        }
    }
}

