/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.CancelledException;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class PasswordDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private boolean cancelled = false;
    private JPasswordField pwdField = new JPasswordField(40);
    private JOptionPane optionPane;
    private final String btnString1 = "OK";
    private final String btnString2 = "Cancel";

    public PasswordDialog(Frame aFrame, String filename) {
        super(aFrame, "Password", true);
        String msgString1 = "Please enter password";
        msgString1 = filename != null ? msgString1 + " for file:\n" + filename + "\n\n" : msgString1 + ":";
        Object[] array = new Object[]{msgString1, this.pwdField};
        Object[] options = new Object[]{"OK", "Cancel"};
        this.optionPane = new JOptionPane(array, -1, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                PasswordDialog.this.optionPane.setValue(-1);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                PasswordDialog.this.pwdField.requestFocusInWindow();
            }
        });
        this.pwdField.addActionListener(this);
        this.optionPane.addPropertyChangeListener(this);
        Point po = new Point(aFrame.getLocationOnScreen());
        Dimension paren_dim = aFrame.getSize();
        int paren_hei = paren_dim.height;
        int paren_wid = paren_dim.width;
        Dimension dial_dim = this.getSize();
        int dial_hei = dial_dim.height;
        int dial_wid = dial_dim.width;
        int dist_X_mid = (paren_wid - dial_wid) / 2;
        int dist_Y_mid = (paren_hei - dial_hei) / 2;
        po.translate(dist_X_mid, dist_Y_mid);
        this.setLocation(po);
    }

    public char[] getPassword() throws CancelledException {
        if (this.cancelled) {
            throw new CancelledException("Password cancelled.");
        }
        return this.pwdField.getPassword();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.optionPane.setValue("OK");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            this.cancelled = !"OK".equals(value);
            this.clearAndHide();
        }
    }

    private void clearAndHide() {
        this.setVisible(false);
    }
}

