/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.Crypto;
import com.pnewman.apps.keyring.Entry;
import com.pnewman.apps.keyring.KeyringEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Vector;

public class Model {
    private static final String APPL_CREATOR_4 = "GkyrGtkr";
    private static final String APPL_CREATOR_5 = "GkyrGtkr";
    public static final boolean DEBUG = false;
    public static final int BUFFER_SIZE = 204800;
    public static final int MAX_ENTRY_SIZE = 102400;
    private static String csvFilename = "keyring.csv";
    private static char csvSeparator = (char)44;
    private byte[] pdbHeader = new byte[78];
    private byte[] pdbCategories = new byte[276];
    private String pdbName;
    private int pdbFlags;
    protected int pdbVersion;
    private long pdbModNumber;
    private int pdbSortInfoOffset;
    private String pdbType;
    private String pdbCreator;
    private int pdbAppInfoOffset;
    private int pdbNumRecords;
    private int recordZeroAttribute;
    private int recordZeroUniqueId;
    private int recordZeroLength;
    private int pdbIterations = 0;
    private Vector<Entry> entries = new Vector();
    private Vector<String> categories = new Vector();
    protected Crypto crypto;
    private static String usingCharset = "ISO-8859-1";

    public Model() {
        if (Charset.isSupported("windows-1252")) {
            usingCharset = "windows-1252";
        }
    }

    public static void writeNewVersion4Database(String filename) {
        int[] header = new int[]{75, 101, 121, 115, 45, 71, 116, 107, 114, 0, 0, 0, 0, 0, 0, 0, 75, 101, 121, 114, 105, 110, 103, 69, 100, 105, 116, 111, 114, 49, 46, 50, 0, 8, 0, 4, 189, 219, 101, 6, 189, 219, 101, 13, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 96, 0, 0, 0, 0, 71, 107, 121, 114, 71, 116, 107, 114, 0, 183, 48, 2, 0, 0, 0, 0, 0, 2, 0, 0, 1, 116, 80, 183, 48, 1, 0, 0, 1, 136, 64, 183, 48, 2, 0, 0, 31, 31};
        int[] data = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 0, 176, 218, 67, 74, 145, 85, 18, 236, 213, 150, 205, 33, 154, 252, 45, 1, 156, 47, 199, 19, 97, 0, 240, 59, 22, 204, 37, 207, 73, 192};
        byte[] cat = new byte[256];
        byte[] cat1 = "no category".getBytes();
        try {
            int i;
            File db = new File(filename);
            FileOutputStream fp = new FileOutputStream(db);
            for (i = 0; i < header.length; ++i) {
                fp.write((byte)header[i]);
            }
            Arrays.fill(cat, (byte)0);
            System.arraycopy(cat1, 0, cat, 0, cat1.length);
            fp.write(cat, 0, 256);
            for (i = 0; i < data.length; ++i) {
                fp.write((byte)data[i]);
            }
            fp.close();
        }
        catch (IOException e) {
            System.err.println("Caught Exception: " + e.getMessage());
        }
    }

    public static void writeNewDatabase(String filename) {
        try {
            int bytesRead;
            byte[] data;
            int bufferSize = 1024;
            try (InputStream stream = KeyringEditor.class.getResourceAsStream("resources/example-keyring-file.pdb");){
                data = new byte[bufferSize];
                bytesRead = stream.read(data);
            }
            if (bytesRead == bufferSize) {
                throw new IOException("Failed to load example database file.");
            }
            File db = new File(filename);
            try (FileOutputStream fp = new FileOutputStream(db);){
                fp.write(data, 0, bytesRead);
            }
        }
        catch (IOException e) {
            System.err.println("Caught Exception: " + e.getMessage());
        }
    }

    public void addEntry(Object entry) {
        this.entries.add((Entry)entry);
    }

    public void removeEntry(Object entry) {
        this.entries.removeElement(entry);
    }

    public int getEntriesSize() {
        return this.entries.size();
    }

    public Vector<Entry> getEntries() {
        return this.entries;
    }

    public Enumeration<Entry> getElements() {
        return this.entries.elements();
    }

    public int getVersion() {
        return this.pdbVersion;
    }

    public int getIterations() {
        return this.pdbIterations;
    }

    public String getCategoryName(int category) throws ArrayIndexOutOfBoundsException {
        return this.categories.get(category);
    }

    public void setCategories(Vector<String> myCategories) {
        this.categories = myCategories;
    }

    public Vector<String> getCategories() {
        return this.categories;
    }

    public void loadDataOriginal(String filename) throws Exception {
        int i;
        byte[] encrypted = null;
        int bufferSize = 204800;
        int emptyTitle = 0;
        int start = 0;
        byte[] iv = null;
        String title = null;
        this.entries.clear();
        this.categories.clear();
        File db = new File(filename);
        FileInputStream fp = new FileInputStream(db);
        byte[] data = new byte[bufferSize];
        int pdbLength = fp.read(data);
        fp.close();
        if (pdbLength == bufferSize) {
            throw new Exception("File too large.");
        }
        this.pdbHeader = Model.sliceBytes(data, 0, 78);
        this.pdbName = Model.sliceString(data, 0, 32);
        this.pdbFlags = (int)Model.sliceNumber(data, 32, 2);
        this.pdbVersion = (int)Model.sliceNumber(data, 34, 2);
        this.pdbModNumber = Model.sliceNumber(data, 48, 4);
        this.pdbAppInfoOffset = (int)Model.sliceNumber(data, 52, 4);
        this.pdbSortInfoOffset = (int)Model.sliceNumber(data, 56, 4);
        this.pdbType = Model.sliceString(data, 60, 4);
        this.pdbCreator = new String(data, 64, 4);
        this.pdbNumRecords = (int)Model.sliceNumber(data, 76, 2);
        if (this.pdbVersion != 4 && this.pdbVersion != 5) {
            throw new Exception("Wrong Keyring database format.");
        }
        if (this.pdbAppInfoOffset != 80 + this.pdbNumRecords * 8) {
            throw new Exception("Bad app info offset.");
        }
        int[] pdbOffset = new int[this.pdbNumRecords];
        int[] pdbAttribute = new int[this.pdbNumRecords];
        int[] pdbUniqueId = new int[this.pdbNumRecords];
        for (i = 0; i < this.pdbNumRecords; ++i) {
            pdbOffset[i] = (int)Model.sliceNumber(data, 78 + i * 8, 4);
            pdbAttribute[i] = (int)Model.sliceNumber(data, 82 + i * 8, 1);
            pdbUniqueId[i] = (int)Model.sliceNumber(data, 83 + i * 8, 3);
        }
        this.pdbCategories = Model.sliceBytes(data, this.pdbAppInfoOffset, 276);
        for (i = 0; i < 16; ++i) {
            String categoryName = Model.sliceString(data, this.pdbAppInfoOffset + 2 + 16 * i, 16);
            if (categoryName.equals("")) continue;
            this.categories.add(categoryName);
        }
        if (this.pdbVersion == 5) {
            if (this.pdbNumRecords <= 0) {
                throw new Exception("No real data.");
            }
            if (pdbOffset[0] != this.pdbAppInfoOffset + 276 + 20) {
                throw new Exception(pdbOffset[0] + ": bad first entry offset, version 5.");
            }
            byte[] salt = Model.sliceBytes(data, this.pdbAppInfoOffset + 276, 8);
            this.pdbIterations = (int)Model.sliceNumber(data, this.pdbAppInfoOffset + 276 + 8, 2);
            int cipher = (int)Model.sliceNumber(data, this.pdbAppInfoOffset + 276 + 8 + 2, 2);
            byte[] hash = Model.sliceBytes(data, this.pdbAppInfoOffset + 276 + 8 + 2 + 2, 8);
            this.crypto = new Crypto(null, 5, salt, hash, this.pdbIterations, cipher);
            start = 0;
            switch (cipher) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new Exception("No cipher not supported.");
                }
            }
            if (this.pdbIterations == 0) {
                throw new Exception(this.pdbIterations + ": bad num iterations, version 5.");
            }
        }
        if (this.pdbVersion == 4) {
            if (this.pdbNumRecords <= 1) {
                throw new Exception("No real data.");
            }
            this.recordZeroAttribute = pdbAttribute[0];
            this.recordZeroUniqueId = pdbUniqueId[0];
            this.recordZeroLength = pdbOffset[1] - pdbOffset[0];
            if (pdbOffset[0] != this.pdbAppInfoOffset + 276) {
                throw new Exception(pdbOffset[0] + " bad first entry offset, version 4.");
            }
            if (this.recordZeroLength < 20) {
                throw new Exception(this.recordZeroLength + " record zero too small, version 4.");
            }
            this.crypto = new Crypto(Model.sliceBytes(data, pdbOffset[0], pdbOffset[1] - pdbOffset[0]), 4);
            start = 1;
        }
        for (int i2 = start; i2 < this.pdbNumRecords; ++i2) {
            if ((pdbAttribute[i2] & 0xF0) != 64) continue;
            int entryLength = i2 == this.pdbNumRecords - 1 ? pdbLength - pdbOffset[i2] : pdbOffset[i2 + 1] - pdbOffset[i2];
            if (entryLength >= 102400) {
                throw new Exception(entryLength + ": entry " + i2 + " too big.");
            }
            if (entryLength > pdbLength - pdbOffset[i2]) {
                throw new Exception("Entry " + i2 + " invalid length " + entryLength + ".");
            }
            if (entryLength <= 0) {
                throw new Exception("Entry " + i2 + " has an invalid length.");
            }
            if (this.pdbVersion == 4) {
                title = Model.sliceString(data, pdbOffset[i2], -1);
                if (entryLength <= title.length() + 1) {
                    throw new Exception("Entry " + i2 + " is empty, version 4.");
                }
                iv = null;
                encrypted = Model.sliceBytes(data, pdbOffset[i2] + title.length() + 1, entryLength - title.length() - 1);
            }
            if (this.pdbVersion == 5) {
                int len = (int)Model.sliceNumber(data, pdbOffset[i2], 2);
                int reallen = len + 1 & 0xFFFFFFFE;
                title = Model.sliceString(data, pdbOffset[i2] + 4, len);
                int ivlen = 8;
                if (this.crypto.type == 2 || this.crypto.type == 3) {
                    ivlen = 16;
                }
                if (entryLength <= reallen + 4 + ivlen) {
                    throw new Exception("Entry " + i2 + " is empty, version 5.");
                }
                iv = Model.sliceBytes(data, pdbOffset[i2] + reallen + 4, ivlen);
                encrypted = Model.sliceBytes(data, pdbOffset[i2] + reallen + 4 + ivlen, entryLength - (reallen + 4 + ivlen));
            }
            if (title != null && title.equals("")) {
                title = "#" + emptyTitle++;
            }
            Entry myEntry = new Entry(i2, title, pdbAttribute[i2] & 0xF, encrypted, this.crypto, pdbAttribute[i2], pdbUniqueId[i2], entryLength, iv);
            this.entries.add(myEntry);
        }
    }

    public void loadData(String filename) throws Exception {
        int bufferSize = 102400;
        int emptyTitle = 0;
        int start = 0;
        byte[] iv = null;
        byte[] encrypted = null;
        String title = null;
        this.entries.clear();
        this.categories.clear();
        File db = new File(filename);
        byte[] data = new byte[bufferSize];
        try (FileInputStream inStream = new FileInputStream(db);){
            int i;
            int bytesRead = inStream.read(data, 0, 78);
            if (bytesRead != 78) {
                throw new Exception("Failed to load file header.");
            }
            this.pdbHeader = Model.sliceBytes(data, 0, 78);
            this.pdbName = Model.sliceString(data, 0, 32);
            this.pdbFlags = (int)Model.sliceNumber(data, 32, 2);
            this.pdbVersion = (int)Model.sliceNumber(data, 34, 2);
            this.pdbModNumber = Model.sliceNumber(data, 48, 4);
            this.pdbAppInfoOffset = (int)Model.sliceNumber(data, 52, 4);
            this.pdbSortInfoOffset = (int)Model.sliceNumber(data, 56, 4);
            this.pdbType = Model.sliceString(data, 60, 4);
            this.pdbCreator = new String(data, 64, 4);
            this.pdbNumRecords = (int)Model.sliceNumber(data, 76, 2);
            if (this.pdbVersion != 4 && this.pdbVersion != 5) {
                throw new Exception("Wrong Keyring database format.");
            }
            if (this.pdbVersion == 5 && this.pdbNumRecords <= 0 || this.pdbVersion == 4 && this.pdbNumRecords <= 1) {
                throw new Exception("No real data.");
            }
            if (this.pdbAppInfoOffset != 80 + this.pdbNumRecords * 8) {
                throw new Exception("Bad app info offset.");
            }
            bytesRead = inStream.read(data, 78, this.pdbAppInfoOffset - 78 + 276);
            if (bytesRead != this.pdbAppInfoOffset - 78 + 276) {
                throw new Exception("Failed to read offsets and categories.");
            }
            int[] pdbOffset = new int[this.pdbNumRecords];
            int[] pdbAttribute = new int[this.pdbNumRecords];
            int[] pdbUniqueId = new int[this.pdbNumRecords];
            for (i = 0; i < this.pdbNumRecords; ++i) {
                pdbOffset[i] = (int)Model.sliceNumber(data, 78 + i * 8, 4);
                pdbAttribute[i] = (int)Model.sliceNumber(data, 82 + i * 8, 1);
                pdbUniqueId[i] = (int)Model.sliceNumber(data, 83 + i * 8, 3);
            }
            this.pdbCategories = Model.sliceBytes(data, this.pdbAppInfoOffset, 276);
            for (i = 0; i < 16; ++i) {
                String categoryName = Model.sliceString(data, this.pdbAppInfoOffset + 2 + 16 * i, 16);
                if (categoryName.equals("")) continue;
                this.categories.add(categoryName);
            }
            if (this.pdbVersion == 5) {
                if (pdbOffset[0] != this.pdbAppInfoOffset + 276 + 20) {
                    throw new Exception(pdbOffset[0] + " bad first entry offset, version 5.");
                }
                bytesRead = inStream.read(data, this.pdbAppInfoOffset + 276, 20);
                if (bytesRead != 20) {
                    throw new Exception("Failed to read cypher init, version 5.");
                }
                byte[] salt = Model.sliceBytes(data, this.pdbAppInfoOffset + 276, 8);
                this.pdbIterations = (int)Model.sliceNumber(data, this.pdbAppInfoOffset + 276 + 8, 2);
                int cipher = (int)Model.sliceNumber(data, this.pdbAppInfoOffset + 276 + 8 + 2, 2);
                byte[] hash = Model.sliceBytes(data, this.pdbAppInfoOffset + 276 + 8 + 2 + 2, 8);
                switch (cipher) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new Exception("Cipher " + cipher + " not supported, version 5.");
                    }
                }
                if (this.pdbIterations < 50) {
                    throw new Exception(this.pdbIterations + " bad num iterations, version 5.");
                }
                this.crypto = new Crypto(null, 5, salt, hash, this.pdbIterations, cipher);
                start = 0;
            }
            if (this.pdbVersion == 4) {
                this.recordZeroAttribute = pdbAttribute[0];
                this.recordZeroUniqueId = pdbUniqueId[0];
                this.recordZeroLength = pdbOffset[1] - pdbOffset[0];
                if (pdbOffset[0] != this.pdbAppInfoOffset + 276) {
                    throw new Exception(pdbOffset[0] + " bad first entry offset, version 4.");
                }
                if (this.recordZeroLength < 20) {
                    throw new Exception(this.recordZeroLength + " record zero too small, version 4.");
                }
                bytesRead = inStream.read(data, 0, this.recordZeroLength);
                if (bytesRead != this.recordZeroLength) {
                    throw new Exception("Failed to read entry zero in version 4.");
                }
                this.crypto = new Crypto(Model.sliceBytes(data, 0, this.recordZeroLength), 4);
                start = 1;
            }
            for (int i2 = start; i2 < this.pdbNumRecords; ++i2) {
                int entryLength;
                if (i2 == this.pdbNumRecords - 1) {
                    entryLength = inStream.read(data);
                    if (entryLength <= 0) continue;
                    if (entryLength == bufferSize) {
                        throw new Exception("Final entry too big.");
                    }
                } else {
                    entryLength = pdbOffset[i2 + 1] - pdbOffset[i2];
                    if (entryLength == 0) continue;
                    if (entryLength < 0) {
                        throw new Exception("Entry " + i2 + " has an invalid length.");
                    }
                    if (entryLength >= bufferSize) {
                        throw new Exception(entryLength + ": entry " + i2 + " too big.");
                    }
                    bytesRead = inStream.read(data, 0, entryLength);
                    if (bytesRead != entryLength) {
                        throw new Exception("Failed to read entry number " + i2 + ".");
                    }
                }
                if ((pdbAttribute[i2] & 0xF0) != 64) continue;
                if (this.pdbVersion == 4) {
                    title = Model.sliceString(data, 0, -1);
                    if (entryLength <= title.length() + 1) {
                        throw new Exception("Entry " + i2 + " is empty, version 4.");
                    }
                    iv = null;
                    encrypted = Model.sliceBytes(data, title.length() + 1, entryLength - title.length() - 1);
                }
                if (this.pdbVersion == 5) {
                    int len = (int)Model.sliceNumber(data, 0, 2);
                    int reallen = len + 1 & 0xFFFFFFFE;
                    title = Model.sliceString(data, 4, len);
                    int ivlen = 8;
                    if (this.crypto.type == 2 || this.crypto.type == 3) {
                        ivlen = 16;
                    }
                    if (entryLength <= reallen + 4 + ivlen) {
                        throw new Exception("Entry " + i2 + " is empty, version 5.");
                    }
                    iv = Model.sliceBytes(data, reallen + 4, ivlen);
                    encrypted = Model.sliceBytes(data, reallen + 4 + ivlen, entryLength - (reallen + 4 + ivlen));
                }
                if (title != null && title.equals("")) {
                    title = "#" + emptyTitle++;
                }
                Entry myEntry = new Entry(i2, title, pdbAttribute[i2] & 0xF, encrypted, this.crypto, pdbAttribute[i2], pdbUniqueId[i2], entryLength, iv);
                this.entries.add(myEntry);
            }
        }
    }

    public void saveData(String filename) throws Exception {
        switch (this.pdbVersion) {
            case 4: {
                this.saveData_4(filename);
                break;
            }
            case 5: {
                this.saveData_5(filename);
            }
        }
    }

    public void saveData_4(String filename) throws Exception {
        Enumeration<Entry> e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = e.nextElement();
            byte[] encodedTitle = Model.stringToByteArray(entry.getTitle());
            int recordLen = encodedTitle.length + entry.encrypted.length + 1;
            if (recordLen == entry.recordLength) continue;
            throw new Exception("Format 4 record '" + entry.getTitle() + "' length " + recordLen + " does not match stored length " + entry.recordLength + ".\nThe database file has not been modified.");
        }
        File db = new File(filename);
        try (FileOutputStream fp = new FileOutputStream(db);){
            Entry entry;
            this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2 + 8;
            this.pdbNumRecords = this.entries.size() + 1;
            int offset = this.pdbAppInfoOffset + 276;
            fp.write(this.pdbHeader, 0, 52);
            fp.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
            fp.write(this.pdbHeader, 56, 20);
            fp.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
            fp.write(Model.numberToByte(offset, 4), 0, 4);
            fp.write(Model.numberToByte(this.recordZeroAttribute, 1), 0, 1);
            fp.write(Model.numberToByte(this.recordZeroUniqueId, 3), 0, 3);
            offset += this.recordZeroLength;
            Enumeration<Entry> e2 = this.entries.elements();
            while (e2.hasMoreElements()) {
                entry = e2.nextElement();
                fp.write(Model.numberToByte(offset, 4), 0, 4);
                fp.write(Model.numberToByte(entry.attribute, 1), 0, 1);
                fp.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
                offset += entry.recordLength;
            }
            fp.write(0);
            fp.write(0);
            this.updateCategories();
            fp.write(this.pdbCategories, 0, 276);
            fp.write(this.crypto.recordZero);
            e2 = this.entries.elements();
            while (e2.hasMoreElements()) {
                entry = e2.nextElement();
                byte[] encodedTitle = Model.stringToByteArray(entry.getTitle());
                fp.write(encodedTitle);
                fp.write(0);
                fp.write(entry.encrypted);
            }
        }
    }

    public void saveData_5(String filename) throws Exception {
        Enumeration<Entry> e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = e.nextElement();
            byte[] encodedTitle = Model.convertStringToField(entry.getTitle(), 0);
            int recordLen = encodedTitle.length + entry.iv.length + entry.encrypted.length;
            if (recordLen == entry.recordLength) continue;
            throw new Exception("Format 5 record '" + entry.getTitle() + "' length " + recordLen + " does not match stored length " + entry.recordLength + ".\nThe database file has not been modified.");
        }
        File db = new File(filename);
        try (FileOutputStream fp = new FileOutputStream(db);){
            Entry entry;
            this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2;
            this.pdbNumRecords = this.entries.size();
            int offset = this.pdbAppInfoOffset + 276 + 20;
            fp.write(this.pdbHeader, 0, 52);
            fp.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
            fp.write(this.pdbHeader, 56, 20);
            fp.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
            Enumeration<Entry> e2 = this.entries.elements();
            while (e2.hasMoreElements()) {
                entry = e2.nextElement();
                fp.write(Model.numberToByte(offset, 4), 0, 4);
                fp.write(Model.numberToByte(entry.attribute, 1), 0, 1);
                fp.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
                offset += entry.recordLength;
            }
            fp.write(0);
            fp.write(0);
            this.updateCategories();
            fp.write(this.pdbCategories, 0, 276);
            fp.write(this.crypto.salt);
            fp.write(Model.numberToByte(this.crypto.iter, 2));
            fp.write(Model.numberToByte(this.crypto.type, 2));
            fp.write(this.crypto.hash);
            e2 = this.entries.elements();
            while (e2.hasMoreElements()) {
                entry = e2.nextElement();
                byte[] encodedTitle = Model.convertStringToField(entry.getTitle(), 0);
                fp.write(encodedTitle);
                fp.write(entry.iv);
                fp.write(entry.encrypted);
            }
        }
    }

    public void convertDatabase(int from, int to, String filename, char[] pw, int type, int iter) throws Exception {
        switch (to) {
            case 4: {
                this.convertTo_4(from, filename, pw);
                break;
            }
            case 5: {
                this.convertTo_5(from, filename, pw, type, iter);
            }
        }
    }

    public void convertTo_4(int from, String filename, char[] pw) throws Exception {
        Entry entry;
        int i;
        byte[] recordzero = new byte[20];
        byte[] pass = new byte[pw.length];
        byte[] salt = new byte[4];
        File db = new File(filename);
        FileOutputStream fp = new FileOutputStream(db);
        this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2 + 8;
        this.pdbNumRecords = this.entries.size() + 1;
        int offset = this.pdbAppInfoOffset + 276;
        Arrays.fill(recordzero, (byte)0);
        if (pw.length > 40) {
            throw new Exception("Password too long.");
        }
        for (i = 0; i < pw.length; ++i) {
            pass[i] = (byte)(0xFF & pw[i]);
        }
        switch (from) {
            case 4: {
                for (i = 0; i < 4; ++i) {
                    salt[i] = this.crypto.recordZero[i];
                    recordzero[i] = this.crypto.recordZero[i];
                }
                break;
            }
            case 5: {
                for (i = 0; i < 4; ++i) {
                    salt[i] = this.crypto.salt[i];
                    recordzero[i] = this.crypto.salt[i];
                }
                break;
            }
        }
        byte[] hash = this.crypto.checkPasswordHash_4(salt, pass);
        for (i = 0; i < 16; ++i) {
            recordzero[i + 4] = hash[i];
        }
        Crypto converted = new Crypto(recordzero, 4);
        converted.setPassword(pw);
        Arrays.fill(pw, '\u0000');
        Arrays.fill(pass, (byte)0);
        fp.write(this.pdbHeader, 0, 34);
        fp.write(Model.numberToByte(4L, 2), 0, 2);
        fp.write(this.pdbHeader, 36, 16);
        fp.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
        fp.write(this.pdbHeader, 56, 4);
        fp.write("GkyrGtkr".getBytes());
        fp.write(this.pdbHeader, 68, 8);
        fp.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
        fp.write(Model.numberToByte(offset, 4), 0, 4);
        fp.write(Model.numberToByte(80L, 1), 0, 1);
        fp.write(Model.numberToByte(0L, 3), 0, 3);
        offset += 20;
        Enumeration<Entry> e = this.entries.elements();
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            fp.write(Model.numberToByte(offset, 4), 0, 4);
            fp.write(Model.numberToByte(entry.attribute, 1), 0, 1);
            fp.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
            byte[] record = Model.toRecordFormat4(entry.getAccount() + "\u0000" + entry.getPassword() + "\u0000" + entry.getNotes() + "\u0000");
            byte[] ciphertext = converted.encrypt(record);
            entry.encrypted = Model.sliceBytes(ciphertext, 16, ciphertext.length - 16);
            byte[] encodedTitle = Model.stringToByteArray(entry.getTitle());
            offset += encodedTitle.length + 1 + entry.encrypted.length;
        }
        fp.write(0);
        fp.write(0);
        this.updateCategories();
        fp.write(this.pdbCategories, 0, 276);
        fp.write(recordzero);
        e = this.entries.elements();
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            fp.write(Model.stringToByteArray(entry.getTitle()));
            fp.write(0);
            fp.write(entry.encrypted);
        }
        converted = null;
        fp.close();
    }

    public void convertTo_5(int from, String filename, char[] pw, int type, int iter) throws Exception {
        Entry entry;
        int i;
        byte[] salthashtype = new byte[20];
        int[] cipherlen = new int[]{0, 24, 16, 32};
        byte[] pass = new byte[pw.length];
        byte[] salt = new byte[8];
        for (i = 0; i < pw.length; ++i) {
            pass[i] = (byte)(0xFF & pw[i]);
        }
        File db = new File(filename);
        FileOutputStream fp = new FileOutputStream(db);
        this.pdbAppInfoOffset = 78 + 8 * this.entries.size() + 2;
        this.pdbNumRecords = this.entries.size();
        int offset = this.pdbAppInfoOffset + 276 + 20;
        switch (from) {
            case 4: {
                for (i = 0; i < 4; ++i) {
                    salt[i] = this.crypto.recordZero[i];
                    salt[i + 4] = this.crypto.recordZero[i];
                }
                break;
            }
            case 5: {
                for (i = 0; i < 8; ++i) {
                    salt[i] = this.crypto.salt[i];
                }
                break;
            }
        }
        byte[] deskey = this.crypto.pbkdf2(pass, salt, iter, cipherlen[type]);
        if (type == 1) {
            for (i = 0; i < 24; ++i) {
                int index = 0xFF & deskey[i];
                deskey[i] = (byte)Crypto.ODD_PARITY[index];
            }
        }
        byte[] digest = this.crypto.getMessageDigest(deskey, salt);
        byte[] hash = Model.sliceBytes(digest, 0, 8);
        Crypto converted = new Crypto(null, 5, salt, hash, iter, type);
        converted.setPassword(pw);
        Arrays.fill(pw, '\u0000');
        Arrays.fill(pass, (byte)0);
        fp.write(this.pdbHeader, 0, 34);
        fp.write(Model.numberToByte(5L, 2), 0, 2);
        fp.write(this.pdbHeader, 36, 16);
        fp.write(Model.numberToByte(this.pdbAppInfoOffset, 4), 0, 4);
        fp.write(this.pdbHeader, 56, 4);
        fp.write("GkyrGtkr".getBytes());
        fp.write(this.pdbHeader, 68, 8);
        fp.write(Model.numberToByte(this.pdbNumRecords, 2), 0, 2);
        Enumeration<Entry> e = this.entries.elements();
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            fp.write(Model.numberToByte(offset, 4), 0, 4);
            fp.write(Model.numberToByte(entry.attribute, 1), 0, 1);
            fp.write(Model.numberToByte(entry.uniqueId, 3), 0, 3);
            byte[] record = Model.toRecordFormat5(entry.getAccount(), entry.getPassword(), entry.getNotes());
            byte[] ciphertext = converted.encrypt(record);
            int ivlen = 8;
            if (type != 1) {
                ivlen = 16;
            }
            entry.iv = Model.sliceBytes(ciphertext, 0, ivlen);
            entry.encrypted = Model.sliceBytes(ciphertext, 16, ciphertext.length - 16);
            byte[] encodedTitle = Model.convertStringToField(entry.getTitle(), 0);
            offset += encodedTitle.length + ivlen + entry.encrypted.length;
        }
        fp.write(0);
        fp.write(0);
        this.updateCategories();
        fp.write(this.pdbCategories, 0, 276);
        fp.write(salt);
        fp.write(Model.numberToByte(iter, 2));
        fp.write(Model.numberToByte(type, 2));
        fp.write(hash);
        e = this.entries.elements();
        while (e.hasMoreElements()) {
            entry = e.nextElement();
            fp.write(Model.convertStringToField(entry.getTitle(), 0));
            fp.write(entry.iv);
            fp.write(entry.encrypted);
        }
        converted = null;
        fp.close();
    }

    public static byte[] toRecordFormat4(String data) {
        byte[] today = Model.getDateType();
        byte[] buffer = Model.stringToByteArray(data);
        byte[] result = new byte[buffer.length + 2];
        System.arraycopy(buffer, 0, result, 0, buffer.length);
        result[buffer.length] = today[1];
        result[buffer.length + 1] = today[0];
        return result;
    }

    public static byte[] toRecordFormat5(String account, String password, String notes) {
        byte[] datetype = new byte[]{0, 2, 3, 0, 0, 0};
        byte[] field1 = account.getBytes();
        byte[] field2 = password.getBytes();
        byte[] field3 = notes.getBytes();
        int lenField1 = field1.length;
        int lenField2 = field2.length;
        int lenField3 = field3.length;
        if (lenField1 != 0) {
            field1 = Model.convertStringToField(account, 1);
            lenField1 = field1.length;
        }
        if (lenField2 != 0) {
            field2 = Model.convertStringToField(password, 2);
            lenField2 = field2.length;
        }
        if (lenField3 != 0) {
            field3 = Model.convertStringToField(notes, 255);
            lenField3 = field3.length;
        }
        byte[] now = Model.getDateType();
        datetype[4] = now[1];
        datetype[5] = now[0];
        int padding = (lenField1 + lenField2 + lenField3 + 6 + 2) % 8;
        byte[] result = new byte[lenField1 + lenField2 + lenField3 + 6 + 2 + padding];
        Arrays.fill(result, (byte)-1);
        if (lenField1 != 0) {
            System.arraycopy(field1, 0, result, 0, lenField1);
        }
        if (lenField2 != 0) {
            System.arraycopy(field2, 0, result, lenField1, lenField2);
        }
        if (lenField3 != 0) {
            System.arraycopy(field3, 0, result, lenField1 + lenField2, lenField3);
        }
        System.arraycopy(datetype, 0, result, lenField1 + lenField2 + lenField3, 6);
        return result;
    }

    public static byte[] convertStringToField(String field, int label) {
        byte[] buffer = Model.stringToByteArray(field);
        int padding = 0;
        int len = buffer.length;
        if (len % 2 == 1) {
            padding = 1;
        }
        byte[] result = new byte[4 + len + padding];
        Arrays.fill(result, (byte)0);
        System.arraycopy(Model.numberToByte(len, 2), 0, result, 0, 2);
        System.arraycopy(Model.numberToByte(label, 1), 0, result, 2, 1);
        result[3] = 0;
        System.arraycopy(buffer, 0, result, 4, len);
        return result;
    }

    public static byte[] stringToByteArray(String data) {
        byte[] buffer;
        try {
            buffer = data.getBytes(usingCharset);
        }
        catch (UnsupportedEncodingException e) {
            buffer = data.getBytes();
        }
        return buffer;
    }

    public int getNewUniqueId() {
        int id = 0;
        Enumeration<Entry> e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = e.nextElement();
            if (entry.getUniqueId() <= id) continue;
            id = entry.getUniqueId();
        }
        return ++id;
    }

    public void saveEntriesToFile(String filename) throws Exception {
        csvFilename = filename;
        File outputFile = new File(csvFilename);
        try (FileWriter out = new FileWriter(outputFile);){
            Enumeration<Entry> e = this.entries.elements();
            while (e.hasMoreElements()) {
                Entry entry = e.nextElement();
                String buffer = this.addEscapeChars(this.categories.elementAt(entry.getCategory())) + csvSeparator + this.addEscapeChars(entry.getTitle()) + csvSeparator + this.addEscapeChars(entry.getAccount()) + csvSeparator + this.addEscapeChars(entry.getPassword()) + csvSeparator + this.addEscapeChars(entry.getNotes()) + "\n";
                out.write(buffer.toCharArray());
            }
        }
    }

    public String addEscapeChars(String text) {
        String newText = text.replace("\\", "\\\\");
        return '\"' + newText.replace("\"", "\\\"") + '\"';
    }

    public void setCsvSeparator(char sep) {
        csvSeparator = sep;
    }

    public void setCsvFilename(String filename) {
        csvFilename = filename;
    }

    public String getCsvFilename() {
        return csvFilename;
    }

    public static byte[] numberToByte(long number, int len) {
        byte[] buffer = new byte[len];
        int i = 0;
        int shift = (len - 1) * 8;
        while (i < len) {
            buffer[i] = (byte)(0xFFL & number >> shift);
            ++i;
            shift -= 8;
        }
        return buffer;
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static byte[] sliceBytes(byte[] data, int start, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = data[start + i];
        }
        return bytes;
    }

    public static long sliceNumber(byte[] data, int start, int length) {
        long value = 0L;
        long factor = 1L;
        for (int i = 0; i < length; ++i) {
            value += (long)Model.unsignedByteToInt(data[start + length - (i + 1)]) * factor;
            factor *= 256L;
        }
        return value;
    }

    public static String sliceString(byte[] data, int start, int length) {
        int realLength = 0;
        if (length == -1) {
            length = data.length - start;
        }
        while (realLength < length && data[start + realLength] != 0) {
            ++realLength;
        }
        try {
            return new String(data, start, realLength, usingCharset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(data, start, realLength);
        }
    }

    public static void printByteArray(String info, byte[] buffer) {
        System.out.print("printByteArray " + info + " (" + buffer.length + "): ");
        for (int i = 0; i < buffer.length; ++i) {
            System.out.print((buffer[i] & 0xFF) + " ");
        }
        System.out.println();
    }

    public static void printHexByteArray(String info, byte[] buffer) {
        char[] hexNumbers = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        System.out.println("printHexByteArray " + info + " (" + buffer.length + "): ");
        for (int i = 0; i < buffer.length; ++i) {
            int zahl = (buffer[i] & 0xFF) / 16;
            int rest = (buffer[i] & 0xFF) % 16;
            System.out.print("" + hexNumbers[zahl] + "" + hexNumbers[rest] + " ");
        }
        System.out.println();
    }

    private void printPDBHeader() {
        System.out.println("PDB Name: " + this.pdbName);
        System.out.println("PDB Flags: " + this.pdbFlags);
        System.out.println("PDB Version: " + this.pdbVersion);
        System.out.println("PDB Modification Number: " + this.pdbModNumber);
        System.out.println("PDB AppInfoOffset: " + this.pdbAppInfoOffset);
        System.out.println("PDB SortInfoOffset: " + this.pdbSortInfoOffset);
        System.out.println("PDB Type: " + this.pdbType);
        System.out.println("PDB Creator: " + this.pdbCreator);
        System.out.println("PDB NumberOfRecords: " + this.pdbNumRecords + "\n");
    }

    private void printEntries() {
        int i = 0;
        Enumeration<String> c = this.categories.elements();
        while (c.hasMoreElements()) {
            String help = c.nextElement();
            System.out.println("Category " + i++ + ": " + help);
        }
        System.out.println();
        Enumeration<Entry> e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = e.nextElement();
            System.out.println(entry.getInfo());
        }
        System.out.println();
    }

    private static byte[] getDateType() {
        int[] intResult = new int[2];
        byte[] byteResult = new byte[2];
        GregorianCalendar rightNow = new GregorianCalendar();
        int day = rightNow.get(5);
        int month = rightNow.get(2) + 1;
        int year = rightNow.get(1) - 1904;
        intResult[0] = (day &= 0x1F) | ((month &= 0xF) & 7) << 5;
        intResult[1] = (year &= 0x7F) << 1 | (month & 8) >> 3;
        byteResult[0] = (byte)intResult[0];
        byteResult[1] = (byte)intResult[1];
        return byteResult;
    }

    private void updateCategories() {
        byte[] cat = new byte[16];
        int index = 0;
        Enumeration<String> c = this.categories.elements();
        while (c.hasMoreElements()) {
            String strCategory = c.nextElement();
            byte[] temp = Model.stringToByteArray(strCategory);
            for (int i = 0; i < 16; ++i) {
                cat[i] = i < temp.length ? temp[i] : (byte)0;
            }
            System.arraycopy(cat, 0, this.pdbCategories, 2 + index * 16, 16);
            ++index;
        }
    }
}

