/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.CancelledException;
import com.pnewman.apps.keyring.CategoriesDialog;
import com.pnewman.apps.keyring.ConvertDialog;
import com.pnewman.apps.keyring.EditDialog;
import com.pnewman.apps.keyring.Entry;
import com.pnewman.apps.keyring.Gui;
import com.pnewman.apps.keyring.Model;
import com.pnewman.apps.keyring.PasswordDialog;
import com.pnewman.apps.keyring.Prop;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class KeyringEditor
extends Gui {
    protected char SEPARATOR = (char)47;
    private File previousDirectory = null;
    private String pdbFilename = "dummy.pdb";
    private Gui gui;
    private Model model;
    private JFrame frame;
    private Gui.PasswordTimeoutWorker timeoutThread;
    private final int filterCategory = -1;
    private boolean textFieldChanged = true;
    private boolean showPassword = true;
    private boolean locked = false;
    private boolean quickstartDisplay = false;
    private static final String APPLE_MAC_EXTENSIONS = "com.apple.eawt.Application";
    private static final String PREF_CURRENT_FILENAME = "current_filename";
    private static final String URL_PROTOCOL = "(https?://|ftp://|www\\.)";
    private static final String URL_FILE = "file:///";
    private static final String URL_DOMAIN = "[a-zA-Z0-9]+([-.][a-zA-Z0-9]+)*\\.[a-zA-Z0-9]+([-][a-zA-Z0-9]+)*";
    private static final String URL_TERMINAL_CHARS = "-\\w+&@#%=~()|";
    private static final String URL_NON_TERMINAL_CHARS = "?!:,.;/";
    private static final String URL_CHARS = "-\\w+&@#%=~()|?!:,.;/";
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?(((https?://|ftp://|www\\.)[a-zA-Z0-9]+([-.][a-zA-Z0-9]+)*\\.[a-zA-Z0-9]+([-][a-zA-Z0-9]+)*)|(file:///))([-\\w+&@#%=~()|?!:,.;/]*[-\\w+&@#%=~()|])?", 2);

    public static void main(String[] args) {
        File currentFile;
        String filename;
        String dbFilename = null;
        KeyringEditor myEditor = new KeyringEditor();
        myEditor.frame = new JFrame("KeyringEditor");
        myEditor.frame.setDefaultCloseOperation(3);
        Preferences prefs = Preferences.userNodeForPackage(KeyringEditor.class);
        if (args.length > 1) {
            System.out.println("Usage: java -jar KeyringEditor.jar [keyring-database]");
            return;
        }
        if (args.length > 0 && !(filename = args[0]).isEmpty() && (currentFile = new File(filename)).isFile()) {
            dbFilename = args[0];
        }
        if (dbFilename == null && !(filename = prefs.get(PREF_CURRENT_FILENAME, "")).isEmpty() && (currentFile = new File(filename)).isFile()) {
            dbFilename = filename;
        }
        try {
            myEditor.setupGui(dbFilename);
        }
        catch (Exception e) {
            myEditor.msgError(e, "main", true);
        }
    }

    public String getFilename() {
        return this.pdbFilename;
    }

    public char getSeparator() {
        return this.SEPARATOR;
    }

    public Model getModel() {
        return this.model;
    }

    public void lockAndClearScreen() {
        this.setBtnLock(true, true);
        this.enableButtons(false);
        this.clearEntry();
    }

    private boolean checkFile(String filename) {
        int n;
        boolean ok = true;
        File f = new File(filename);
        if (f.exists() && (n = JOptionPane.showConfirmDialog(this.frame, "File already exists. Continue?", "Warning", 0)) == 1) {
            ok = false;
        }
        return ok;
    }

    private void msgError(Exception e, String info, boolean showStack) {
        JOptionPane.showMessageDialog(this.frame, info + ": " + e.getMessage(), "Keyring Error", 0);
        if (showStack) {
            e.printStackTrace(System.err);
        }
    }

    private void msgAlert(String msg) {
        JOptionPane.showMessageDialog(this.frame, msg, "Keyring Error", 0);
    }

    private void msgInformation(String info) {
        JOptionPane.showMessageDialog(this.frame, info, "Keyring Information", 1);
    }

    private int msgConfirm(String query) {
        return JOptionPane.showConfirmDialog(this.frame, query, "Keyring Confirm", 0, 3);
    }

    private void setupGui(String dbFilename) throws Exception {
        JMenuBar myMenuBar = this.setMenuBar();
        this.frame.setJMenuBar(myMenuBar);
        JSplitPane mySplitPane = this.setLayout(this);
        this.frame.setContentPane(mySplitPane);
        this.openMenuItem.addActionListener(new OpenListener(this));
        this.closeMenuItem.addActionListener(new CloseListener(this));
        this.quitMenuItem.addActionListener(new QuitListener(this));
        this.categoriesMenuItem.addActionListener(new editCategoriesListener(this));
        this.csvMenuItem.addActionListener(new csvListener(this));
        this.aboutMenuItem.addActionListener(new AboutListener(this));
        this.quickstartMenuItem.addActionListener(new QuickstartListener(this));
        this.convertMenuItem.addActionListener(new convertListener(this));
        this.newMenuItem.addActionListener(new newListener(this));
        this.currentCategory.addActionListener(new currentCategorySelectionListener(this));
        this.currentTitle.getDocument().addDocumentListener(new documentListener(this));
        this.currentAccountName.getDocument().addDocumentListener(new documentListener(this));
        this.currentPassword.getDocument().addDocumentListener(new documentListener(this));
        this.currentNotes.getDocument().addDocumentListener(new documentListener(this));
        this.categoryList.addActionListener(new CategorySelectionListener(this));
        this.dynTree.getTree().addTreeSelectionListener(new treeSelectionListener(this));
        this.newEntry.addActionListener(new newEntryListener(this));
        this.saveEntry.addActionListener(new saveEntryListener(this));
        this.delEntry.addActionListener(new delEntryListener(this));
        this.btnLock.addActionListener(new PasswordLockListener(this));
        this.currentPasswordShow.addActionListener(new PasswordShowListener(this));
        this.currentNotes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    KeyringEditor.this.checkForURL();
                }
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
        this.frame.setLocation(0, 120);
        ArrayList<Image> imageList = new ArrayList<Image>();
        imageList.add(this.createImage("keyring-icon-16.png"));
        imageList.add(this.createImage("keyring-icon-32a.png"));
        imageList.add(this.createImage("keyring-icon-96.png"));
        this.frame.setIconImages(imageList);
        if (this.systemIsAMac()) {
            Image macIcon = this.createImage("keyring-icon-96.png");
            try {
                Class<?> cls = Class.forName(APPLE_MAC_EXTENSIONS);
                Object application = cls.newInstance().getClass().getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                application.getClass().getMethod("setDockIconImage", Image.class).invoke(application, macIcon);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        this.timeoutThread = new Gui.PasswordTimeoutWorker(this);
        new Thread(this.timeoutThread).start();
        if (dbFilename == null) {
            this.displayQuickstartFile();
        }
        this.loadDatabase(dbFilename);
    }

    private void loadDatabase(String dbFilename) throws Exception {
        String[] dbType = new String[]{"TripleDES", "TripleDES", "AES128", "AES256"};
        if (dbFilename != null) {
            this.model = new Model();
            try {
                this.model.loadData(dbFilename);
                this.pdbFilename = dbFilename;
                this.setupProperties(this.model.getElements());
            }
            catch (Exception ex) {
                this.msgError(ex, "Open keyring database", false);
                try {
                    this.loadDatabase(null);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!this.checkPassword()) {
                this.loadDatabase(null);
                return;
            }
            if (this.model.getVersion() == 4) {
                this.msgInformation("This is a version 4 file, an old file format that is no longer secure.\nPlease use Tools/Convert database to update the format to version 5\nwith AES128 or AES256 encryption. For help see pnewman.com/keyring.");
            }
            this.frame.setTitle("KeyringEditor: " + dbFilename + " (" + dbType[this.model.crypto.type] + " | Database format " + this.model.pdbVersion + ")");
            this.setupCategories(this.model.getCategories());
            this.setMenuBar(false);
            this.enableButtons(true);
            this.setBtnLock(false, true);
            this.dynTree.populate();
            this.currentNotes.setText("");
            Preferences prefs = Preferences.userNodeForPackage(KeyringEditor.class);
            prefs.put(PREF_CURRENT_FILENAME, dbFilename);
        } else {
            this.model = null;
            this.frame.setTitle("KeyringEditor");
            this.setupCategories(null);
            this.setMenuBar(true);
            this.enableButtons(false);
            this.setBtnLock(false, false);
            this.dynTree.clear();
        }
        this.quickstartDisplay = false;
    }

    private void setupProperties(Enumeration entries) {
        Prop myProp = new Prop(this);
        myProp.setup();
        Enumeration e = entries;
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            entry.setTitleSeparator(this.SEPARATOR);
        }
    }

    private void setMenuBar(boolean open) {
        this.openMenuItem.setEnabled(open);
        this.closeMenuItem.setEnabled(!open);
        this.csvMenuItem.setEnabled(!open);
        this.categoriesMenuItem.setEnabled(!open);
        this.convertMenuItem.setEnabled(!open);
    }

    private void enableButtons(boolean enabled) {
        this.delEntry.setEnabled(false);
        this.saveEntry.setEnabled(false);
        this.newEntry.setEnabled(enabled);
        this.enableFields(enabled);
    }

    private void enableFields(boolean flag) {
        this.currentCategory.setEditable(false);
        this.currentTitle.setEditable(flag);
        this.currentAccountName.setEditable(flag);
        this.currentPassword.setEditable(flag);
        this.currentNotes.setEditable(flag);
    }

    private void setBtnLock(boolean locked, boolean enabled) {
        this.btnLock.setText(locked ? "Unlock" : "Lock");
        this.btnLock.setEnabled(enabled);
        this.locked = locked;
        this.saveEntry.setBackground(null);
    }

    private void setupCategories(Vector myCategories) {
        Vector<String> displayCategories = myCategories != null ? (Vector<String>)myCategories.clone() : new Vector<String>();
        displayCategories.add(0, "All");
        this.categoryList.setModel(new DefaultComboBoxModel(displayCategories));
        Vector currentCategories = myCategories != null ? (Vector)myCategories.clone() : new Vector();
        this.currentCategory.setModel(new DefaultComboBoxModel(currentCategories));
    }

    private boolean checkPassword() {
        try {
            this.model.crypto.setPassword(this.getPasswordDialog());
            this.timeoutThread.restartTimeout();
            return true;
        }
        catch (CancelledException e) {
            this.timeoutThread.setTimeout();
            return false;
        }
        catch (Exception e) {
            this.msgError(e, "checkPassword", false);
            this.timeoutThread.setTimeout();
            return false;
        }
    }

    private char[] getPasswordDialog() throws Exception {
        PasswordDialog pwdDlg = new PasswordDialog((Frame)this.frame, this.pdbFilename);
        pwdDlg.pack();
        pwdDlg.setVisible(true);
        return pwdDlg.getPassword();
    }

    private void showEntry() {
        DefaultMutableTreeNode node = this.dynTree.getLastNode();
        if (this.locked) {
            return;
        }
        try {
            Date ende = this.timeoutThread.getEndDate();
            if (ende == null) {
                this.clearEntry();
                this.setBtnLock(true, true);
                this.enableButtons(false);
                this.saveEntry.setBackground(null);
                return;
            }
            this.timeoutThread.restartTimeout();
            if (node == null || !node.isLeaf() || node.isRoot()) {
                this.clearEntry();
                this.saveEntry.setEnabled(false);
                this.saveEntry.setBackground(null);
                this.delEntry.setEnabled(false);
                return;
            }
            Object nodeInfo = node.getUserObject();
            Entry e = (Entry)nodeInfo;
            if (this.currentCategory.getItemCount() > e.getCategory()) {
                this.currentCategory.setSelectedIndex(e.getCategory());
            } else {
                this.currentCategory.setSelectedIndex(0);
            }
            this.currentTitle.setText(e.getTitle());
            this.currentAccountName.setText(e.getAccount());
            this.currentNotes.setText(e.getNotes());
            this.currentNotes.setCaretPosition(0);
            this.currentPassword.setText(e.getPassword());
            this.currentDate.setText(e.getDate());
            this.textFieldChanged = false;
            this.saveEntry.setEnabled(false);
            this.saveEntry.setBackground(null);
            this.delEntry.setEnabled(true);
            this.quickstartDisplay = false;
        }
        catch (Exception e) {
            this.msgError(e, "showEntry", true);
            try {
                this.loadDatabase(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void clearEntry() {
        this.currentTitle.setText("");
        this.currentAccountName.setText("");
        this.currentPassword.setText("");
        this.currentNotes.setText("");
        this.currentDate.setText("");
        this.quickstartDisplay = false;
    }

    public Image createImage(String path) {
        URL imgURL = KeyringEditor.class.getResource("resources/" + path);
        if (imgURL != null) {
            Toolkit kit = Toolkit.getDefaultToolkit();
            return kit.createImage(imgURL);
        }
        return null;
    }

    private boolean systemIsAMac() {
        try {
            Class.forName(APPLE_MAC_EXTENSIONS, false, null);
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private void displayQuickstartFile() {
        String textFile = "KeyringEditor version 1.2\n\n";
        try (InputStream stream = KeyringEditor.class.getResourceAsStream("resources/quickstart.txt");){
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = r.readLine()) != null) {
                textFile = textFile + line + "\n";
            }
            this.currentNotes.setText(textFile);
            this.currentNotes.setCaretPosition(0);
        }
        catch (IOException e) {
            this.msgError(e, "Display text resource", false);
        }
    }

    private void saveEntry(KeyringEditor editor) {
        DefaultMutableTreeNode node = editor.dynTree.getLastNode();
        byte[] record = null;
        int recordLength = 0;
        int ivLen = 8;
        try {
            if (node != null) {
                Entry myEntry = editor.dynTree.getEntry(node);
                char[] temp = editor.currentPassword.getPassword();
                switch (this.model.pdbVersion) {
                    case 4: {
                        record = Model.toRecordFormat4(editor.currentAccountName.getText() + "\u0000" + new String(temp) + "\u0000" + editor.currentNotes.getText() + "\u0000");
                        break;
                    }
                    case 5: {
                        record = Model.toRecordFormat5(editor.currentAccountName.getText(), new String(temp), editor.currentNotes.getText());
                        if (this.model.crypto.type == 1) break;
                        ivLen = 16;
                    }
                }
                byte[] ciphertext = editor.model.crypto.encrypt(record);
                byte[] encodedTitle = Model.stringToByteArray(editor.currentTitle.getText());
                int len = encodedTitle.length + ciphertext.length - 16;
                switch (this.model.pdbVersion) {
                    case 4: {
                        recordLength = len + 1;
                        break;
                    }
                    case 5: {
                        recordLength = len + 4 + len % 2 + ivLen;
                    }
                }
                int maxTextLen = 102399;
                if (recordLength > maxTextLen) {
                    this.msgAlert("Text exceeds maximum length for an entry of " + maxTextLen + " bytes.");
                    return;
                }
                myEntry.title = editor.currentTitle.getText();
                myEntry.encrypted = Model.sliceBytes(ciphertext, 16, ciphertext.length - 16);
                myEntry.category = editor.currentCategory.getSelectedIndex();
                myEntry.attribute = editor.currentCategory.getSelectedIndex() | 0x40;
                myEntry.recordLength = recordLength;
                myEntry.iv = Model.sliceBytes(ciphertext, 0, ivLen);
                this.saveEntry.setEnabled(false);
                this.saveEntry.setBackground(null);
                editor.dynTree.populate();
                editor.model.saveData(this.pdbFilename);
                editor.dynTree.show(myEntry);
                this.msgInformation("Entries saved to: " + editor.pdbFilename);
            }
        }
        catch (Exception ex) {
            this.msgError(ex, "saveEntryListener", true);
        }
    }

    private void checkForURL() {
        int charIndex;
        String cardText = this.currentNotes.getText();
        int len = cardText.length();
        if (len < 4) {
            return;
        }
        int endIndex = charIndex = this.currentNotes.getCaretPosition();
        if (charIndex == len) {
            --charIndex;
        }
        while (charIndex > 0 && Character.isWhitespace(cardText.charAt(charIndex))) {
            --charIndex;
        }
        while (charIndex >= 0 && !Character.isWhitespace(cardText.charAt(charIndex))) {
            --charIndex;
        }
        ++charIndex;
        while (endIndex < len && !Character.isWhitespace(cardText.charAt(endIndex))) {
            ++endIndex;
        }
        if (endIndex - charIndex < 3) {
            return;
        }
        String extract = cardText.substring(charIndex, endIndex);
        Matcher urlMatcher = URL_PATTERN.matcher(extract);
        if (urlMatcher.find()) {
            String urlStr = urlMatcher.group();
            endIndex = charIndex + urlMatcher.end();
            charIndex += urlMatcher.start();
            if (urlStr.startsWith("(")) {
                ++charIndex;
                if (urlStr.endsWith(")")) {
                    --endIndex;
                }
            }
            String finalUrl = cardText.substring(charIndex, endIndex);
            this.currentNotes.setCaretPosition(endIndex);
            this.currentNotes.moveCaretPosition(charIndex);
            this.currentNotes.getCaret().setSelectionVisible(true);
            if (!Desktop.isDesktopSupported()) {
                return;
            }
            Desktop desktop = Desktop.getDesktop();
            if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                return;
            }
            URI uri = null;
            try {
                uri = new URI(finalUrl);
                desktop.browse(uri);
            }
            catch (IOException | URISyntaxException ex) {
                this.msgError(ex, "Launch browser url: \"" + uri + "\"", false);
            }
        }
    }

    public class PasswordLockListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected PasswordLockListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.editor.locked) {
                this.editor.setBtnLock(true, true);
                this.editor.enableButtons(false);
                this.editor.clearEntry();
            } else if (this.editor.checkPassword()) {
                this.editor.setBtnLock(false, true);
                this.editor.enableButtons(true);
                this.editor.showEntry();
            }
        }
    }

    public class PasswordShowListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected PasswordShowListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!KeyringEditor.this.showPassword) {
                KeyringEditor.this.showPassword = true;
                this.editor.currentPassword.setEchoChar('\u0000');
            } else {
                KeyringEditor.this.showPassword = false;
                this.editor.currentPassword.setEchoChar('*');
            }
        }
    }

    public class currentCategorySelectionListener
    implements ActionListener {
        protected KeyringEditor editor;

        public currentCategorySelectionListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(this.editor.textFieldChanged || this.editor.locked || KeyringEditor.this.quickstartDisplay)) {
                this.editor.textFieldChanged = true;
                this.editor.saveEntry.setEnabled(true);
                this.editor.saveEntry.setBackground(Color.YELLOW);
            }
        }
    }

    public class CategorySelectionListener
    implements ActionListener {
        protected KeyringEditor editor;

        public CategorySelectionListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.editor.dynTree.setCategoryFilter(this.editor.categoryList.getSelectedIndex());
            this.editor.showEntry();
        }
    }

    public class treeSelectionListener
    implements TreeSelectionListener {
        protected KeyringEditor editor;
        boolean treeSelectionListenerEnabled = true;

        protected treeSelectionListener(KeyringEditor editor) {
            this.editor = editor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            int n;
            if (!this.treeSelectionListenerEnabled) {
                return;
            }
            if (KeyringEditor.this.locked) {
                KeyringEditor.this.msgInformation("Please unlock application first.");
                return;
            }
            if (this.editor.saveEntry.isEnabled() && (n = KeyringEditor.this.msgConfirm("There are unsaved changes.\nWould you like to save them?")) == 0) {
                Entry newEntry = null;
                DefaultMutableTreeNode node = this.editor.dynTree.getLastNode();
                if (node != null && !node.isRoot()) {
                    newEntry = this.editor.dynTree.getEntry(node);
                }
                TreePath oldTreePath = e.getOldLeadSelectionPath();
                this.treeSelectionListenerEnabled = false;
                try {
                    KeyringEditor.this.dynTree.getTree().setSelectionPath(oldTreePath);
                }
                finally {
                    this.treeSelectionListenerEnabled = true;
                }
                KeyringEditor.this.saveEntry(this.editor);
                if (newEntry != null) {
                    this.editor.dynTree.show(newEntry);
                }
            }
            this.editor.showEntry();
        }
    }

    public class documentListener
    implements DocumentListener {
        protected KeyringEditor editor;

        protected documentListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateLog(e, "insert");
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateLog(e, "remove");
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateLog(e, "changed");
        }

        public void updateLog(DocumentEvent e, String action) {
            if (!(this.editor.textFieldChanged || this.editor.locked || KeyringEditor.this.quickstartDisplay)) {
                this.editor.textFieldChanged = true;
                this.editor.saveEntry.setEnabled(true);
                this.editor.saveEntry.setBackground(Color.YELLOW);
            }
        }
    }

    public class delEntryListener
    implements ActionListener {
        protected KeyringEditor editor;

        public delEntryListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultMutableTreeNode node = this.editor.dynTree.getLastNode();
            Entry myEntry = this.editor.dynTree.getEntry(node);
            if (node != null) {
                int n = KeyringEditor.this.msgConfirm("Are you sure you want to delete entry '" + myEntry.getTitle() + "'?");
                if (n != 0) {
                    return;
                }
                this.editor.model.removeEntry(myEntry);
                this.editor.dynTree.populate();
                try {
                    this.editor.model.saveData(KeyringEditor.this.pdbFilename);
                    KeyringEditor.this.msgInformation("Entry '" + myEntry.getTitle() + "' deleted.\nDatabase file '" + this.editor.pdbFilename + "' saved.");
                }
                catch (Exception ex) {
                    KeyringEditor.this.msgError(ex, "delEntryListener", false);
                }
            }
        }
    }

    public class saveEntryListener
    implements ActionListener {
        protected KeyringEditor editor;

        public saveEntryListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyringEditor.this.saveEntry(this.editor);
        }
    }

    public class newEntryListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected newEntryListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditDialog editDlg = new EditDialog((Frame)this.editor.frame, this.editor.model.getCategories());
            editDlg.pack();
            editDlg.setVisible(true);
            Object[] buffer = editDlg.getNewEntry();
            byte[] record = null;
            int recordLength = 0;
            int newEntryId = this.editor.model.getEntriesSize() + 1;
            int ivLen = 8;
            try {
                if (buffer[0] != null) {
                    switch (((KeyringEditor)KeyringEditor.this).model.pdbVersion) {
                        case 4: {
                            record = Model.toRecordFormat4((String)buffer[2] + "\u0000" + (String)buffer[3] + "\u0000" + (String)buffer[4] + "\u0000");
                            break;
                        }
                        case 5: {
                            record = Model.toRecordFormat5((String)buffer[2], (String)buffer[3], (String)buffer[4]);
                            if (((KeyringEditor)KeyringEditor.this).model.crypto.type == 1) break;
                            ivLen = 16;
                        }
                    }
                    byte[] ciphertext = ((KeyringEditor)this.editor).model.crypto.encrypt(record);
                    byte[] encodedTitle = Model.stringToByteArray((String)buffer[1]);
                    int len = encodedTitle.length + ciphertext.length - 16;
                    switch (((KeyringEditor)KeyringEditor.this).model.pdbVersion) {
                        case 4: {
                            recordLength = len + 1;
                            break;
                        }
                        case 5: {
                            recordLength = len + 4 + len % 2 + ivLen;
                        }
                    }
                    int maxTextLen = 102399;
                    if (recordLength > maxTextLen) {
                        KeyringEditor.this.msgAlert("Text exceeds maximum length for an entry of " + maxTextLen + " bytes.");
                        return;
                    }
                    int id = this.editor.model.getNewUniqueId();
                    Entry myEntry = new Entry(newEntryId, (String)buffer[1], (Integer)buffer[0], Model.sliceBytes(ciphertext, 16, ciphertext.length - 16), ((KeyringEditor)this.editor).model.crypto, (int)((Integer)buffer[0] | 0x40), id, recordLength, Model.sliceBytes(ciphertext, 0, ivLen));
                    this.editor.model.addEntry(myEntry);
                    this.editor.dynTree.populate();
                    this.editor.model.saveData(KeyringEditor.this.pdbFilename);
                    this.editor.dynTree.show(myEntry);
                }
            }
            catch (Exception ex) {
                KeyringEditor.this.msgError(ex, "newEntryListener", true);
            }
        }
    }

    public class QuickstartListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected QuickstartListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.editor.saveEntry.isEnabled()) {
                KeyringEditor.this.msgInformation("Please save the entry first.");
            } else {
                KeyringEditor.this.clearEntry();
                KeyringEditor.this.quickstartDisplay = true;
                KeyringEditor.this.displayQuickstartFile();
                KeyringEditor.this.saveEntry.setEnabled(false);
                KeyringEditor.this.saveEntry.setBackground(null);
                KeyringEditor.this.delEntry.setEnabled(false);
            }
        }
    }

    public class AboutListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected AboutListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String[] dbType = new String[]{"TripleDES", "TripleDES", "AES128", "AES256"};
            String fileDetails = "";
            if (KeyringEditor.this.model != null) {
                fileDetails = fileDetails + "File: " + KeyringEditor.this.pdbFilename;
                fileDetails = fileDetails + "\nFile format version: " + ((KeyringEditor)KeyringEditor.this).model.pdbVersion;
                fileDetails = fileDetails + "\nAlgorithm: " + dbType[((KeyringEditor)KeyringEditor.this).model.crypto.type];
                if (((KeyringEditor)KeyringEditor.this).model.pdbVersion == 5) {
                    fileDetails = fileDetails + "\nIterations: " + KeyringEditor.this.model.getIterations();
                }
                fileDetails = fileDetails + "\nEntries: " + KeyringEditor.this.model.getEntriesSize();
                fileDetails = fileDetails + "\n\n";
            }
            JOptionPane.showMessageDialog(this.editor.frame, "KeyringEditor 1.2\n\nCopyright 2022 Peter Newman\npnewman.com/keyring\n\n" + fileDetails + "KeyringEditor v" + "1.2" + " is based on:\nKeyringEditor v1.1\nCopyright 2005 Markus Griessnig\nVienna University of Technology\nInstitute of Computer Technology\n\nKeyringEditor v1.1 is based on:\nJava Keyring v0.6\nCopyright 2004 Frank Taylor <keyring@lieder.me.uk>\n\nThis program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License as\npublished by the Free Software Foundation; either version 3 of\nthe License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\nSee the GNU General Public License for more details.\n", "About", 1);
        }
    }

    public class newListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected newListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Generate new minimal database");
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(KeyringEditor.this.previousDirectory);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Keyring '.pdb' file", "pdb");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showSaveDialog(this.editor.frame);
            if (returnVal == 0) {
                try {
                    boolean ok;
                    File selectedFile = chooser.getSelectedFile();
                    KeyringEditor.this.previousDirectory = selectedFile.getParentFile();
                    String newFilename = selectedFile.getCanonicalPath();
                    if (!newFilename.toLowerCase().endsWith(".pdb")) {
                        newFilename = newFilename + ".pdb";
                    }
                    if (ok = KeyringEditor.this.checkFile(newFilename)) {
                        Model.writeNewDatabase(newFilename);
                        KeyringEditor.this.msgInformation("New minimal database with password 'test' generated.");
                    }
                }
                catch (IOException ex) {
                    KeyringEditor.this.msgError(ex, "Failed to generate new file.", false);
                }
            }
        }
    }

    public class convertListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected convertListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (KeyringEditor.this.locked) {
                KeyringEditor.this.msgInformation("Please unlock application first.");
                return;
            }
            ConvertDialog catDialog = new ConvertDialog((Frame)this.editor.frame, this.editor.model, ((KeyringEditor)this.editor).model.pdbVersion);
            catDialog.pack();
            catDialog.setVisible(true);
            if (!catDialog.getCancelled()) {
                KeyringEditor.this.msgInformation("Database converted.");
                try {
                    this.editor.loadDatabase(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class csvListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected csvListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (KeyringEditor.this.locked) {
                KeyringEditor.this.msgInformation("Please unlock application first.");
                return;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Save Keyring database to CSV-File");
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(KeyringEditor.this.previousDirectory);
            int returnVal = chooser.showSaveDialog(this.editor.frame);
            if (returnVal == 0) {
                try {
                    File selectedFile = chooser.getSelectedFile();
                    KeyringEditor.this.previousDirectory = selectedFile.getParentFile();
                    String csvFilename = selectedFile.getCanonicalPath();
                    if (csvFilename.equalsIgnoreCase(KeyringEditor.this.pdbFilename)) {
                        KeyringEditor.this.msgAlert("Cannot overwrite database file: " + KeyringEditor.this.pdbFilename);
                        return;
                    }
                    boolean ok = KeyringEditor.this.checkFile(csvFilename);
                    if (ok) {
                        this.editor.model.saveEntriesToFile(csvFilename);
                        KeyringEditor.this.msgInformation("Entries saved to: " + KeyringEditor.this.model.getCsvFilename());
                    }
                }
                catch (Exception ex) {
                    KeyringEditor.this.msgError(ex, "Could not save entries to " + KeyringEditor.this.model.getCsvFilename(), false);
                }
            }
        }
    }

    public class editCategoriesListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected editCategoriesListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (KeyringEditor.this.locked) {
                KeyringEditor.this.msgInformation("Please unlock application first.");
                return;
            }
            CategoriesDialog catDialog = new CategoriesDialog((Frame)KeyringEditor.this.frame, KeyringEditor.this.model.getCategories());
            catDialog.pack();
            catDialog.setVisible(true);
            Vector<String> newCategories = catDialog.getNewCategories();
            if (newCategories != null) {
                KeyringEditor.this.setupCategories(newCategories);
                KeyringEditor.this.model.setCategories(newCategories);
                try {
                    this.editor.model.saveData(KeyringEditor.this.pdbFilename);
                }
                catch (Exception ex) {
                    KeyringEditor.this.msgError(ex, "Could not save entries to " + KeyringEditor.this.pdbFilename, false);
                }
            }
        }
    }

    public class QuitListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected QuitListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    public class CloseListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected CloseListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                this.editor.loadDatabase(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class OpenListener
    implements ActionListener {
        protected KeyringEditor editor;

        protected OpenListener(KeyringEditor editor) {
            this.editor = editor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Open Keyring database");
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(KeyringEditor.this.previousDirectory);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Keyring '.pdb' file", "pdb");
            chooser.setFileFilter(filter);
            int returnVal = chooser.showOpenDialog(this.editor.frame);
            if (returnVal == 0) {
                try {
                    File selectedFile = chooser.getSelectedFile();
                    KeyringEditor.this.previousDirectory = selectedFile.getParentFile();
                    KeyringEditor.this.pdbFilename = selectedFile.getCanonicalPath();
                    this.editor.loadDatabase(KeyringEditor.this.pdbFilename);
                }
                catch (Exception ex) {
                    KeyringEditor.this.msgError(ex, "Open Keyring database", false);
                    try {
                        this.editor.loadDatabase(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

