/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.DynamicTree;
import com.pnewman.apps.keyring.KeyringEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Gui {
    protected static final String VERSION = "1.2";
    protected static final String FRAMETITLE = "KeyringEditor";
    protected static long PASSWORD_TIMEOUT = 1200000L;
    protected JMenuBar menuBar;
    protected JMenuItem openMenuItem;
    protected JMenuItem closeMenuItem;
    protected JMenuItem quitMenuItem;
    protected JMenuItem categoriesMenuItem;
    protected JMenuItem csvMenuItem;
    protected JMenuItem convertMenuItem;
    protected JMenuItem newMenuItem;
    protected JMenuItem aboutMenuItem;
    protected JMenuItem quickstartMenuItem;
    protected JComboBox categoryList;
    protected DynamicTree dynTree;
    protected JComboBox currentCategory;
    protected JTextField currentTitle;
    protected JTextField currentAccountName;
    protected JPasswordField currentPassword;
    protected JTextField currentDate;
    protected JTextArea currentNotes;
    protected JButton saveEntry;
    protected JButton newEntry;
    protected JButton delEntry;
    protected JButton btnLock;
    protected JCheckBox currentPasswordShow;

    protected JMenuBar setMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        this.menuBar.add(fileMenu);
        this.openMenuItem = new JMenuItem("Open", 79);
        fileMenu.add(this.openMenuItem);
        this.closeMenuItem = new JMenuItem("Close", 67);
        fileMenu.add(this.closeMenuItem);
        this.closeMenuItem.setEnabled(false);
        fileMenu.addSeparator();
        this.quitMenuItem = new JMenuItem("Quit", 81);
        fileMenu.add(this.quitMenuItem);
        JMenu catMenu = new JMenu("Tools");
        catMenu.setMnemonic(84);
        this.menuBar.add(catMenu);
        this.categoriesMenuItem = new JMenuItem("Edit categories", 69);
        catMenu.add(this.categoriesMenuItem);
        catMenu.addSeparator();
        this.csvMenuItem = new JMenuItem("Save to CSV file", 83);
        catMenu.add(this.csvMenuItem);
        this.convertMenuItem = new JMenuItem("Convert database", 67);
        catMenu.add(this.convertMenuItem);
        this.newMenuItem = new JMenuItem("New database file", 78);
        catMenu.add(this.newMenuItem);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        this.menuBar.add(helpMenu);
        this.aboutMenuItem = new JMenuItem("About", 65);
        helpMenu.add(this.aboutMenuItem);
        this.quickstartMenuItem = new JMenuItem("Quickstart", 81);
        helpMenu.add(this.quickstartMenuItem);
        return this.menuBar;
    }

    protected JSplitPane setLayout(KeyringEditor editor) {
        int gridy = 0;
        this.categoryList = new JComboBox();
        this.dynTree = new DynamicTree(editor);
        this.currentCategory = new JComboBox();
        this.currentTitle = new JTextField();
        this.currentAccountName = new JTextField();
        this.currentPassword = new JPasswordField();
        this.currentDate = new JTextField();
        this.currentDate.setEnabled(false);
        this.currentNotes = new JTextArea();
        this.currentNotes.setLineWrap(true);
        this.currentNotes.setWrapStyleWord(true);
        this.currentPassword.setEchoChar('\u0000');
        this.currentPasswordShow = new JCheckBox("Hide Passwords?", false);
        this.btnLock = new JButton("Lock");
        this.newEntry = new JButton("New Entry");
        this.saveEntry = new JButton("Save");
        this.delEntry = new JButton("Delete");
        JPanel entryListPane = new JPanel();
        entryListPane.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel entryPane = new JPanel();
        entryPane.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gridbag1 = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        entryListPane.setLayout(gridbag1);
        c.ipadx = 2;
        c.ipady = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag1.setConstraints(this.categoryList, c);
        entryListPane.add(this.categoryList);
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridbag1.setConstraints(this.dynTree, c);
        entryListPane.add(this.dynTree);
        GridBagLayout gridbag2 = new GridBagLayout();
        entryPane.setLayout(gridbag2);
        c.ipadx = 2;
        c.ipady = 2;
        c.insets = new Insets(2, 2, 2, 2);
        c.anchor = 18;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabel categoryLabel = new JLabel("Category: ");
        c.gridx = 0;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        gridbag2.setConstraints(categoryLabel, c);
        entryPane.add(categoryLabel);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        gridbag2.setConstraints(this.currentCategory, c);
        entryPane.add(this.currentCategory);
        JLabel titleLabel = new JLabel("Title: ");
        c.gridx = 0;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        gridbag2.setConstraints(titleLabel, c);
        entryPane.add(titleLabel);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        gridbag2.setConstraints(this.currentTitle, c);
        entryPane.add(this.currentTitle);
        JLabel accountNameLabel = new JLabel("Account: ");
        c.gridx = 0;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        gridbag2.setConstraints(accountNameLabel, c);
        entryPane.add(accountNameLabel);
        c.gridx = 1;
        c.gridwidth = 0;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        gridbag2.setConstraints(this.currentAccountName, c);
        entryPane.add(this.currentAccountName);
        JLabel passwordLabel = new JLabel("    Password: ");
        c.gridx = 0;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        gridbag2.setConstraints(passwordLabel, c);
        entryPane.add(passwordLabel);
        c.gridx = 1;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        gridbag2.setConstraints(this.currentPassword, c);
        entryPane.add(this.currentPassword);
        JLabel dateLabel = new JLabel("Date: ");
        c.gridx = 0;
        c.gridy = gridy++;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        gridbag2.setConstraints(dateLabel, c);
        entryPane.add(dateLabel);
        c.gridx = 1;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 1.0;
        gridbag2.setConstraints(this.currentDate, c);
        entryPane.add(this.currentDate);
        c.gridx = 0;
        c.gridy = gridy++;
        c.gridwidth = 0;
        c.fill = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane currentNotesScroll = new JScrollPane(this.currentNotes);
        gridbag2.setConstraints(currentNotesScroll, c);
        entryPane.add(currentNotesScroll);
        c.gridx = 0;
        c.gridy = gridy;
        c.gridwidth = 1;
        c.fill = 2;
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        gridbag2.setConstraints(this.saveEntry, c);
        entryPane.add(this.saveEntry);
        buttonPane.setLayout(new BoxLayout(buttonPane, 0));
        buttonPane.add(this.newEntry);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(this.delEntry);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(this.btnLock);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(this.currentPasswordShow);
        JSplitPane top = new JSplitPane(0, entryPane, buttonPane);
        top.setResizeWeight(1.0);
        JSplitPane contentPane = new JSplitPane(1, entryListPane, top);
        contentPane.setResizeWeight(0.33);
        entryListPane.setMinimumSize(new Dimension(200, 440));
        entryPane.setMinimumSize(new Dimension(300, 400));
        buttonPane.setMinimumSize(new Dimension(300, 40));
        entryListPane.setPreferredSize(new Dimension(200, 440));
        entryPane.setPreferredSize(new Dimension(500, 400));
        buttonPane.setPreferredSize(new Dimension(500, 40));
        return contentPane;
    }

    protected class PasswordTimeoutWorker
    implements Runnable {
        private final KeyringEditor editor;
        private Date endDate = null;
        private final Object sleepGate = new Object();

        public PasswordTimeoutWorker(KeyringEditor editor) {
            this.editor = editor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void restartTimeout() {
            this.endDate = new Date(new Date().getTime() + PASSWORD_TIMEOUT);
            Object object = this.sleepGate;
            synchronized (object) {
                this.sleepGate.notifyAll();
            }
        }

        public synchronized void setTimeout() {
            this.endDate = null;
        }

        public synchronized Date getEndDate() {
            return this.endDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                if (this.endDate != null) {
                    Date now = new Date();
                    long difference = this.endDate.getTime() - now.getTime();
                    if (difference <= 0L) {
                        this.editor.lockAndClearScreen();
                        this.endDate = null;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    Object object = this.sleepGate;
                    synchronized (object) {
                        this.sleepGate.wait();
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

