/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.Crypto;

public class Entry
implements Comparable<Entry> {
    private static char SEPARATOR = (char)47;
    protected int entryId;
    protected String title;
    protected int category;
    protected byte[] encrypted;
    protected byte[] iv;
    protected int attribute;
    protected int uniqueId;
    protected int recordLength;
    private final Crypto crypto;

    public Entry(int entryId, String title, int category, byte[] encrypted, Crypto crypto, int attribute, int uniqueId, int recordLength, byte[] iv) {
        this.entryId = entryId;
        this.title = title;
        this.category = category;
        this.encrypted = encrypted;
        this.crypto = crypto;
        this.attribute = attribute;
        this.uniqueId = uniqueId;
        this.recordLength = recordLength;
        this.iv = iv;
    }

    public int getUniqueId() {
        return this.uniqueId;
    }

    public void setTitleSeparator(char sep) {
        SEPARATOR = sep;
    }

    public int getEntryId() {
        return this.entryId;
    }

    public String getTitle() {
        return this.title;
    }

    public int getCategory() {
        return this.category;
    }

    public String getAccount() {
        String temp = (String)this.crypto.decrypt(this.encrypted, "account", this.iv);
        if (temp == null) {
            return "";
        }
        return temp;
    }

    public String getPassword() {
        String temp = (String)this.crypto.decrypt(this.encrypted, "password", this.iv);
        if (temp == null) {
            return "";
        }
        return temp;
    }

    public String getNotes() {
        String temp = (String)this.crypto.decrypt(this.encrypted, "notes", this.iv);
        if (temp == null) {
            return "";
        }
        return temp;
    }

    public String getDate() {
        int d;
        int m;
        int y;
        byte[] buffer = (byte[])this.crypto.decrypt(this.encrypted, "datetype", this.iv);
        try {
            y = ((buffer[0] & 0xFE) >> 1) + 1904;
            m = ((buffer[0] & 1) << 3) + ((buffer[1] & 0xE0) >> 5);
            d = buffer[1] & 0x1F;
        }
        catch (Exception e) {
            return "11.11.2004";
        }
        return d + "." + m + "." + y;
    }

    public byte[] getAll() {
        byte[] buffer = (byte[])this.crypto.decrypt(this.encrypted, "", this.iv);
        return buffer;
    }

    public String getInfo() {
        return "EntryId: " + this.entryId + " = " + this.title + " + " + this.getAccount() + " + " + this.getPassword() + " (" + this.recordLength + ", " + this.getDate() + ", " + this.getCategory() + ")";
    }

    public String toString() {
        int i = this.title.lastIndexOf(SEPARATOR);
        if (i != -1) {
            return this.title.substring(i + 1, this.title.length());
        }
        return this.title;
    }

    @Override
    public int compareTo(Entry e) {
        return this.title.toLowerCase().compareTo(e.getTitle().toLowerCase());
    }
}

