/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.Entry;
import com.pnewman.apps.keyring.KeyringEditor;
import com.pnewman.apps.keyring.Model;
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JPanel {
    private final DefaultMutableTreeNode rootNode;
    private final DefaultTreeModel treeModel;
    private final JTree tree;
    private final JScrollPane scrollPane;
    private final KeyringEditor editor;
    private int filterCategory = 0;

    public DynamicTree(KeyringEditor editor) {
        super(new GridLayout(1, 0));
        this.editor = editor;
        this.rootNode = new DefaultMutableTreeNode("");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.scrollPane = new JScrollPane(this.tree);
        this.add(this.scrollPane);
    }

    public void show(Object newentry) {
        Enumeration<TreeNode> enum1 = this.rootNode.depthFirstEnumeration();
        while (enum1.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enum1.nextElement();
            if (node == null || !node.isLeaf()) continue;
            Object nodeInfo = node.getUserObject();
            Entry e1 = (Entry)nodeInfo;
            Entry e2 = (Entry)newentry;
            if (e1.getEntryId() != e2.getEntryId()) continue;
            this.tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean setCategoryFilter(int filterCategory) {
        boolean changed = filterCategory != this.filterCategory;
        this.filterCategory = filterCategory;
        this.populate();
        return changed;
    }

    public void clearFilter() {
        this.filterCategory = 0;
        this.populate();
    }

    public Entry getEntry(DefaultMutableTreeNode node) {
        Object nodeInfo = node.getUserObject();
        return (Entry)nodeInfo;
    }

    public DefaultMutableTreeNode getLastNode() {
        DefaultMutableTreeNode temp = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (temp != null && temp.isLeaf()) {
            return temp;
        }
        return null;
    }

    public void reload() {
        this.treeModel.reload();
    }

    public void clear() {
        this.rootNode.setUserObject("");
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode currentNode;
        MutableTreeNode parent;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (parent = (MutableTreeNode)(currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(currentNode);
        }
    }

    public void populate() {
        this.clear();
        this.rootNode.setUserObject(this.editor.getFilename());
        Model myModel = this.editor.getModel();
        if (myModel == null) {
            return;
        }
        Vector myEntries = (Vector)myModel.getEntries().clone();
        Collections.sort(myEntries);
        Enumeration e = myEntries.elements();
        while (e.hasMoreElements()) {
            int i;
            Entry entry = (Entry)e.nextElement();
            if (this.filterCategory != 0 && this.filterCategory - 1 != entry.getCategory()) continue;
            int start = 0;
            DefaultMutableTreeNode startNode = this.rootNode;
            String title = entry.getTitle();
            while ((i = title.indexOf(this.editor.getSeparator(), start)) != -1) {
                String parent = title.substring(start, i);
                String child = title.substring(i + 1, title.length());
                start = i + 1;
                DefaultMutableTreeNode node = DynamicTree.searchForBranchNode(startNode, parent);
                if (node == null) {
                    Dummy dummy = new Dummy(parent);
                    node = this.addObject(startNode, dummy, true);
                }
                startNode = node;
            }
            this.addObject(startNode, entry, true);
        }
        this.scrollPane.getVerticalScrollBar().setValue(0);
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode parent, Object child, boolean shouldBeVisible) {
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
        if (parent == null) {
            parent = this.rootNode;
        }
        this.treeModel.insertNodeInto(childNode, parent, parent.getChildCount());
        if (shouldBeVisible) {
            this.tree.scrollPathToVisible(new TreePath(childNode.getPath()));
        }
        return childNode;
    }

    private static DefaultMutableTreeNode searchForBranchNode(DefaultMutableTreeNode root, String category) {
        Enumeration<TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            try {
                Dummy branch = (Dummy)node.getUserObject();
                if (!category.equals(branch.toString())) continue;
                return node;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static class Dummy {
        String title;

        public Dummy(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

