/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.Model;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class Crypto {
    protected static final int[] ODD_PARITY = new int[]{1, 1, 2, 2, 4, 4, 7, 7, 8, 8, 11, 11, 13, 13, 14, 14, 16, 16, 19, 19, 21, 21, 22, 22, 25, 25, 26, 26, 28, 28, 31, 31, 32, 32, 35, 35, 37, 37, 38, 38, 41, 41, 42, 42, 44, 44, 47, 47, 49, 49, 50, 50, 52, 52, 55, 55, 56, 56, 59, 59, 61, 61, 62, 62, 64, 64, 67, 67, 69, 69, 70, 70, 73, 73, 74, 74, 76, 76, 79, 79, 81, 81, 82, 82, 84, 84, 87, 87, 88, 88, 91, 91, 93, 93, 94, 94, 97, 97, 98, 98, 100, 100, 103, 103, 104, 104, 107, 107, 109, 109, 110, 110, 112, 112, 115, 115, 117, 117, 118, 118, 121, 121, 122, 122, 124, 124, 127, 127, 128, 128, 131, 131, 133, 133, 134, 134, 137, 137, 138, 138, 140, 140, 143, 143, 145, 145, 146, 146, 148, 148, 151, 151, 152, 152, 155, 155, 157, 157, 158, 158, 161, 161, 162, 162, 164, 164, 167, 167, 168, 168, 171, 171, 173, 173, 174, 174, 176, 176, 179, 179, 181, 181, 182, 182, 185, 185, 186, 186, 188, 188, 191, 191, 193, 193, 194, 194, 196, 196, 199, 199, 200, 200, 203, 203, 205, 205, 206, 206, 208, 208, 211, 211, 213, 213, 214, 214, 217, 217, 218, 218, 220, 220, 223, 223, 224, 224, 227, 227, 229, 229, 230, 230, 233, 233, 234, 234, 236, 236, 239, 239, 241, 241, 242, 242, 244, 244, 247, 247, 248, 248, 251, 251, 253, 253, 254, 254};
    protected static final int SALT_SIZE = 4;
    protected static final int MD5_CBLOCK = 64;
    protected static final int MD5_DIGEST_LENGTH = 16;
    protected static final int KDESBLOCKSIZE = 8;
    protected byte[] recordZero;
    private final int version;
    protected byte[] salt = new byte[8];
    protected byte[] hash = new byte[8];
    protected int iter;
    protected int type;
    protected SecretKey key = null;
    protected Cipher cipher = null;

    public Crypto(byte[] recordZero, int version) {
        this.recordZero = recordZero;
        this.version = version;
    }

    public Crypto(byte[] recordZero, int version, byte[] salt, byte[] hash, int iter, int type) {
        this.recordZero = recordZero;
        this.version = version;
        this.salt = salt;
        this.hash = hash;
        this.iter = iter;
        this.type = type;
    }

    public void setPassword(char[] password) throws Exception {
        switch (this.version) {
            case 4: {
                this.setPassword_4(password);
                break;
            }
            case 5: {
                this.setPassword_5(password);
            }
        }
    }

    public void setPassword_5(char[] password) throws Exception {
        byte[] digest;
        byte[] help;
        int[] cipherlen = new int[]{0, 24, 16, 32};
        byte[] pass = new byte[password.length];
        for (int i = 0; i < password.length; ++i) {
            pass[i] = (byte)(0xFF & password[i]);
        }
        byte[] deskey = this.pbkdf2(pass, this.salt, this.iter, cipherlen[this.type]);
        if (this.type == 1) {
            for (int i = 0; i < 24; ++i) {
                int index = 0xFF & deskey[i];
                deskey[i] = (byte)ODD_PARITY[index];
            }
        }
        if (!Arrays.equals(this.hash, help = Model.sliceBytes(digest = this.getMessageDigest(deskey, this.salt), 0, this.hash.length))) {
            throw new Exception("Password incorrect.");
        }
        for (int i = 0; i < pass.length; ++i) {
            pass[i] = 0;
        }
        switch (this.type) {
            case 1: {
                this.key = SecretKeyFactory.getInstance("DESede").generateSecret(new DESedeKeySpec(deskey));
                this.cipher = Cipher.getInstance("TripleDES/CBC/NoPadding");
                break;
            }
            case 2: {
                this.key = new SecretKeySpec(Model.sliceBytes(deskey, 0, 16), "AES");
                this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
                break;
            }
            case 3: {
                this.key = new SecretKeySpec(Model.sliceBytes(deskey, 0, 32), "AES");
                this.cipher = Cipher.getInstance("AES/CBC/NoPadding");
                break;
            }
            default: {
                throw new Exception("Cipher " + this.type + " not supported.");
            }
        }
    }

    public byte[] getMessageDigest(byte[] key, byte[] salt) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(key);
        md.update(salt);
        return md.digest();
    }

    public byte[] pbkdf2(byte[] pass, byte[] salt, int iter, int keylen) throws Exception {
        int SHA_DIGEST_LENGTH = 20;
        int i = 1;
        byte[] itmp = new byte[4];
        int pos = 0;
        byte[] p = new byte[keylen];
        Mac mac = Mac.getInstance("HmacSHA1");
        mac.init(new SecretKeySpec(pass, "HmacSHA1"));
        while (keylen > 0) {
            int blocklen = keylen > SHA_DIGEST_LENGTH ? SHA_DIGEST_LENGTH : keylen;
            itmp[0] = (byte)(0xFF & i >> 24);
            itmp[1] = (byte)(0xFF & i >> 16);
            itmp[2] = (byte)(0xFF & i >> 8);
            itmp[3] = (byte)(0xFF & i);
            mac.reset();
            mac.update(salt);
            byte[] digtmp = mac.doFinal(itmp);
            System.arraycopy(digtmp, 0, p, pos, blocklen);
            for (int j = 1; j < iter; ++j) {
                mac.reset();
                digtmp = mac.doFinal(digtmp);
                for (int k = 0; k < blocklen; ++k) {
                    int n = pos + k;
                    p[n] = (byte)(p[n] ^ digtmp[k]);
                }
            }
            keylen -= blocklen;
            pos += blocklen;
            ++i;
        }
        return p;
    }

    public byte[] hmac(byte[] text, byte[] key, String hashfunction) throws Exception {
        int BLOCKSIZE = 64;
        byte[] ipad = new byte[BLOCKSIZE];
        byte[] opad = new byte[BLOCKSIZE];
        Arrays.fill(ipad, (byte)0);
        Arrays.fill(opad, (byte)0);
        System.arraycopy(key, 0, ipad, 0, key.length);
        System.arraycopy(key, 0, opad, 0, key.length);
        for (int i = 0; i < BLOCKSIZE; ++i) {
            ipad[i] = (byte)(0x36 ^ ipad[i]);
            opad[i] = (byte)(0x5C ^ opad[i]);
        }
        MessageDigest md = MessageDigest.getInstance(hashfunction);
        md.update(ipad);
        md.update(text);
        byte[] digest = md.digest();
        md.reset();
        md.update(opad);
        md.update(digest);
        digest = md.digest();
        return digest;
    }

    public void setPassword_4(char[] password) throws Exception {
        int i;
        byte[] desKeyData = new byte[24];
        byte[] pass = new byte[password.length];
        for (i = 0; i < password.length; ++i) {
            pass[i] = (byte)(0xFF & password[i]);
        }
        for (i = 0; i < password.length; ++i) {
            password[i] = '\u0000';
        }
        if (pass.length > 40) {
            throw new Exception("Password too long.");
        }
        byte[] passwdHash = this.checkPasswordHash_4(this.recordZero, pass);
        if (!Arrays.equals(passwdHash, Model.sliceBytes(this.recordZero, 4, 16))) {
            throw new Exception("Password incorrect.");
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(pass);
        byte[] snib = md.digest();
        for (i = 0; i < 16; ++i) {
            desKeyData[i] = snib[i];
            if (i >= 8) continue;
            desKeyData[i + 16] = snib[i];
        }
        this.key = SecretKeyFactory.getInstance("DESede").generateSecret(new DESedeKeySpec(desKeyData));
        this.cipher = Cipher.getInstance("TripleDES/ECB/NoPadding");
        for (i = 0; i < pass.length; ++i) {
            pass[i] = 0;
        }
    }

    protected byte[] checkPasswordHash_4(byte[] salt, byte[] pass) throws Exception {
        int i;
        byte[] msg = new byte[64];
        Arrays.fill(msg, (byte)0);
        for (i = 0; i < 4; ++i) {
            msg[i] = salt[i];
        }
        for (i = 0; i < pass.length; ++i) {
            msg[i + 4] = pass[i];
        }
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(msg);
        return md.digest();
    }

    public Object decrypt(byte[] cipherText, String fieldName, byte[] iv) {
        Object temp = null;
        switch (this.version) {
            case 4: {
                temp = this.decrypt_4(cipherText, fieldName);
                break;
            }
            case 5: {
                temp = this.decrypt_5(cipherText, fieldName, iv);
            }
        }
        return temp;
    }

    public Object decrypt_5(byte[] encrypted, String fieldName, byte[] iv) {
        String account = null;
        String password = null;
        String notes = null;
        byte[] datetype = null;
        byte[] plain = null;
        int pos = 0;
        try {
            switch (this.type) {
                case 1: {
                    AlgorithmParameters params = AlgorithmParameters.getInstance("DES");
                    params.init(new IvParameterSpec(iv));
                    this.cipher.init(2, (Key)this.key, params);
                    plain = this.cipher.update(encrypted);
                    break;
                }
                case 2: 
                case 3: {
                    AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
                    params.init(new IvParameterSpec(iv));
                    this.cipher.init(2, (Key)this.key, params);
                    plain = this.cipher.doFinal(encrypted);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return "Could not decrypt data.";
        }
        if (plain == null) {
            return "Failed to decrypt data.";
        }
        int len = (int)Model.sliceNumber(plain, pos, 2);
        while (len != 65535) {
            int reallen = len + 1 & 0xFFFFFFFE;
            int label = (int)Model.sliceNumber(plain, pos + 2, 1);
            switch (label) {
                case 1: {
                    account = Model.sliceString(plain, pos + 4, len);
                    break;
                }
                case 2: {
                    password = Model.sliceString(plain, pos + 4, len);
                    break;
                }
                case 3: {
                    datetype = Model.sliceBytes(plain, pos + 4, 2);
                    break;
                }
                case 255: {
                    notes = Model.sliceString(plain, pos + 4, len);
                }
            }
            pos = pos + reallen + 4;
            if (pos < plain.length - 2) {
                len = (int)Model.sliceNumber(plain, pos, 2);
                continue;
            }
            len = 65535;
        }
        if (fieldName.equals("account")) {
            return account;
        }
        if (fieldName.equals("password")) {
            return password;
        }
        if (fieldName.equals("notes")) {
            return notes;
        }
        if (fieldName.equals("datetype")) {
            return datetype;
        }
        return null;
    }

    public Object decrypt_4(byte[] cipherText, String fieldName) {
        int posPlain = 0;
        int nextItem = 0;
        int len = cipherText.length;
        byte[] plainText = new byte[len];
        try {
            int j;
            byte[] buffer;
            int i;
            this.cipher.init(2, this.key);
            for (i = 0; i < len / 8; ++i) {
                buffer = this.cipher.update(cipherText, i * 8, 8);
                for (j = 0; j < buffer.length; ++j) {
                    plainText[posPlain++] = buffer[j];
                }
            }
            int rest = len % 8;
            buffer = new byte[8];
            for (i = 0; i < 8; ++i) {
                buffer[i] = i < rest ? cipherText[len - rest + i] : (byte)0;
            }
            byte[] buffer2 = this.cipher.doFinal(buffer);
            for (j = 0; j < rest; ++j) {
                plainText[posPlain++] = buffer2[j];
            }
        }
        catch (Exception e) {
            return "Could not decrypt data.";
        }
        String account = Model.sliceString(plainText, nextItem, -1);
        String password = Model.sliceString(plainText, nextItem += account.length() + 1, -1);
        String notes = Model.sliceString(plainText, nextItem += password.length() + 1, -1);
        byte[] datetype = Model.sliceBytes(plainText, nextItem += notes.length() + 1, 2);
        if (fieldName.equals("account")) {
            return account;
        }
        if (fieldName.equals("password")) {
            return password;
        }
        if (fieldName.equals("notes")) {
            return notes;
        }
        if (fieldName.equals("datetype")) {
            return datetype;
        }
        return plainText;
    }

    public byte[] encrypt(byte[] plainText) throws Exception {
        byte[] temp = null;
        block0 : switch (this.version) {
            case 4: {
                temp = this.encrypt_des_aes(plainText, 8);
                break;
            }
            case 5: {
                switch (this.type) {
                    case 1: {
                        temp = this.encrypt_des_aes(plainText, 8);
                        break block0;
                    }
                    case 2: {
                        temp = this.encrypt_des_aes(plainText, 16);
                        break block0;
                    }
                    case 3: {
                        temp = this.encrypt_des_aes(plainText, 16);
                    }
                }
            }
        }
        return temp;
    }

    public byte[] encrypt_des_aes(byte[] plainText, int blocksize) throws Exception {
        int j;
        byte[] buffer;
        int i;
        int cpos = 0;
        int plen = plainText.length;
        int clen = plen % blocksize != 0 ? plen + (blocksize - plen % blocksize) : plen;
        byte[] cipherText = new byte[clen];
        this.cipher.init(1, this.key);
        byte[] iv = this.cipher.getIV();
        for (i = 0; i < plen / blocksize; ++i) {
            buffer = this.cipher.update(plainText, i * blocksize, blocksize);
            for (j = 0; j < buffer.length; ++j) {
                cipherText[cpos++] = buffer[j];
            }
        }
        int rest = plen % blocksize;
        if (rest != 0) {
            buffer = new byte[blocksize];
            for (i = 0; i < blocksize; ++i) {
                buffer[i] = i < rest ? plainText[plen - rest + i] : (byte)0;
            }
            byte[] buffer2 = this.cipher.doFinal(buffer);
            for (j = 0; j < blocksize; ++j) {
                cipherText[cpos] = buffer2[j];
                ++cpos;
            }
        }
        byte[] temp = new byte[16 + cipherText.length];
        Arrays.fill(temp, (byte)0);
        if (iv != null) {
            System.arraycopy(iv, 0, temp, 0, iv.length);
        }
        System.arraycopy(cipherText, 0, temp, 16, cipherText.length);
        return temp;
    }
}

