/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import com.pnewman.apps.keyring.Model;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ConvertDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private final Frame frame;
    private final JComboBox cboCipher;
    private final JComboBox cboIter;
    private JPasswordField password;
    private final Model model;
    private final int fromFormat;
    private JOptionPane optionPane;
    private final String btnString1 = "OK";
    private final String btnString2 = "Cancel";
    private boolean cancelled = false;

    public ConvertDialog(Frame frame, Model model, int fromFormat) {
        super(frame, "Convert database", true);
        this.frame = frame;
        this.model = model;
        this.fromFormat = fromFormat;
        ArrayList<String> cipher = new ArrayList<String>();
        cipher.add("TripleDES | (insecure) format 4");
        cipher.add("TripleDES | (insecure) format 5");
        cipher.add("AES128 | Database format 5");
        cipher.add("AES256 | Database format 5");
        this.cboCipher = new JComboBox<Object>(cipher.toArray());
        this.cboCipher.setModel(new DefaultComboBoxModel<Object>(cipher.toArray()));
        this.cboCipher.setSelectedIndex(2);
        ArrayList<Integer> iter = new ArrayList<Integer>();
        iter.add(50);
        iter.add(250);
        iter.add(500);
        iter.add(1000);
        iter.add(10000);
        this.cboIter = new JComboBox<Object>(iter.toArray());
        this.cboIter.setModel(new DefaultComboBoxModel<Object>(iter.toArray()));
        this.cboIter.setSelectedIndex(4);
        this.password = new JPasswordField(20);
        String msgString1 = "Cipher: ";
        String msgString2 = "Iterations: ";
        String msgString3 = "New password: ";
        Object[] array = new Object[]{msgString1, this.cboCipher, msgString2, this.cboIter, msgString3, this.password};
        Object[] options = new Object[]{"OK", "Cancel"};
        this.optionPane = new JOptionPane(array, -1, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ConvertDialog.this.optionPane.setValue(-1);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                ConvertDialog.this.password.requestFocusInWindow();
            }
        });
        this.optionPane.addPropertyChangeListener(this);
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if ("OK".equals(value)) {
                if (this.password.getPassword().length == 0) {
                    JOptionPane.showMessageDialog(this, "Sorry, password must not be empty!\n", "Error", 0);
                    this.cancelled = true;
                    this.password.requestFocusInWindow();
                    return;
                }
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Convert Keyring database");
                chooser.setFileSelectionMode(0);
                chooser.setMultiSelectionEnabled(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Keyring '.pdb' file", "pdb");
                chooser.setFileFilter(filter);
                int returnVal = chooser.showSaveDialog(this.frame);
                if (returnVal == 0) {
                    try {
                        File selectedFile = chooser.getSelectedFile();
                        String toFilename = selectedFile.getCanonicalPath();
                        if (!toFilename.toLowerCase().endsWith(".pdb")) {
                            toFilename = toFilename + ".pdb";
                        }
                        int toFormat = 0;
                        int type = this.cboCipher.getSelectedIndex();
                        switch (type) {
                            case 0: {
                                toFormat = 4;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                toFormat = 5;
                            }
                        }
                        this.model.convertDatabase(this.fromFormat, toFormat, toFilename, this.password.getPassword(), type, (Integer)this.cboIter.getSelectedItem());
                    }
                    catch (Exception ex) {
                        this.cancelled = true;
                        JOptionPane.showMessageDialog(this.frame, "Convert database: " + ex.getMessage(), "Error", 0);
                        ex.printStackTrace(System.err);
                    }
                } else {
                    this.cancelled = true;
                }
            } else {
                this.cancelled = true;
            }
            this.clearAndHide();
        }
    }

    private void clearAndHide() {
        this.password.setText(null);
        this.setVisible(false);
    }
}

