/*
 * Decompiled with CFR 0.152.
 */
package com.pnewman.apps.keyring;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class CategoriesDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private final Frame frame;
    private JOptionPane optionPane;
    private final String btnString1 = "OK";
    private final String btnString2 = "Cancel";
    private final String btnString3 = "Delete";
    private final JComboBox allCategories;
    private JTextField editCategory;
    private int index = 0;
    private Vector myCategories;

    public CategoriesDialog(Frame frame, Vector cat) {
        super(frame, "Edit categories", true);
        this.frame = frame;
        this.myCategories = new Vector();
        Enumeration e = cat.elements();
        while (e.hasMoreElements()) {
            Object temp = e.nextElement();
            this.myCategories.add(temp);
        }
        for (int i = this.myCategories.size(); i < 16; ++i) {
            String empty = "- empty -";
            this.myCategories.add(empty);
        }
        this.allCategories = new JComboBox(this.myCategories);
        this.allCategories.setModel(new DefaultComboBoxModel(this.myCategories));
        this.editCategory = new JTextField(16);
        Object[] array = new Object[]{this.allCategories, this.editCategory};
        Object[] options = new Object[]{"OK", "Cancel", "Delete"};
        this.optionPane = new JOptionPane(array, -1, 0, null, options, options[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                CategoriesDialog.this.optionPane.setValue(-1);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent ce) {
                CategoriesDialog.this.editCategory.requestFocusInWindow();
            }
        });
        this.allCategories.addActionListener(this);
        this.optionPane.addPropertyChangeListener(this);
        this.editCategory.setText((String)this.allCategories.getSelectedItem());
    }

    public Vector<String> getNewCategories() {
        return this.myCategories;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String temp = this.editCategory.getText();
        if (this.index == 0 && temp.equals("- empty -")) {
            JOptionPane.showMessageDialog(this.frame, "First Categoryname is not deleteable.", "Information", 1);
            this.editCategory.setText((String)this.allCategories.getSelectedItem());
            this.index = this.allCategories.getSelectedIndex();
        } else {
            this.myCategories.setElementAt(temp, this.index);
            this.editCategory.setText((String)this.allCategories.getSelectedItem());
            this.index = this.allCategories.getSelectedIndex();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.optionPane && ("value".equals(prop) || "inputValue".equals(prop))) {
            Object value = this.optionPane.getValue();
            if (value == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if ("OK".equals(value)) {
                String lastCategory = this.editCategory.getText();
                this.myCategories.setElementAt(lastCategory, this.index);
                Vector<String> temp = new Vector<String>();
                Enumeration elem = this.myCategories.elements();
                while (elem.hasMoreElements()) {
                    String category = (String)elem.nextElement();
                    if (category.length() > 15) {
                        JOptionPane.showMessageDialog(this.frame, "Categoryname '" + category + "' will be shrinked to 15 characters.", "Information", 1);
                        category = category.substring(0, 15);
                    }
                    if (category.equals("- empty -")) continue;
                    temp.add(category);
                }
                this.myCategories = temp;
                this.clearAndHide();
            } else if ("Delete".equals(value)) {
                this.editCategory.setText("- empty -");
                this.index = this.allCategories.getSelectedIndex();
                this.allCategories.setSelectedIndex(0);
            } else {
                this.myCategories = null;
                this.clearAndHide();
            }
        }
    }

    private void clearAndHide() {
        this.editCategory.setText(null);
        this.setVisible(false);
    }
}

