/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class Gui {
    protected static final String VERSION = "1.1";
    protected static final String FRAMETITLE = "KeyringEditor";
    protected static long PASSWORD_TIMEOUT = 60000L;
    protected JMenuBar menuBar;
    protected JMenuItem openMenuItem;
    protected JMenuItem closeMenuItem;
    protected JMenuItem quitMenuItem;
    protected JMenuItem categoriesMenuItem;
    protected JMenuItem csvMenuItem;
    protected JMenuItem convertMenuItem;
    protected JMenuItem newMenuItem;
    protected JMenuItem aboutMenuItem;
    protected JComboBox categoryList;
    protected DynamicTree dynTree;
    protected JComboBox currentCategory;
    protected JTextField currentTitle;
    protected JTextField currentAccountName;
    protected JPasswordField currentPassword;
    protected JTextField currentDate;
    protected JTextArea currentNotes;
    protected JButton saveEntry;
    protected JButton newEntry;
    protected JButton delEntry;
    protected JButton btnLock;
    protected JCheckBox currentPasswordShow;

    protected JMenuBar setMenuBar() {
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        this.menuBar.add(jMenu);
        this.openMenuItem = new JMenuItem("Open", 79);
        jMenu.add(this.openMenuItem);
        this.closeMenuItem = new JMenuItem("Close", 67);
        jMenu.add(this.closeMenuItem);
        this.closeMenuItem.setEnabled(false);
        jMenu.addSeparator();
        this.quitMenuItem = new JMenuItem("Quit", 81);
        jMenu.add(this.quitMenuItem);
        JMenu jMenu2 = new JMenu("Tools");
        jMenu2.setMnemonic(84);
        this.menuBar.add(jMenu2);
        this.categoriesMenuItem = new JMenuItem("Edit categories", 69);
        jMenu2.add(this.categoriesMenuItem);
        jMenu2.addSeparator();
        this.csvMenuItem = new JMenuItem("Save to CSV file", 83);
        jMenu2.add(this.csvMenuItem);
        this.convertMenuItem = new JMenuItem("Convert database", 67);
        jMenu2.add(this.convertMenuItem);
        this.newMenuItem = new JMenuItem("New minimal database", 78);
        jMenu2.add(this.newMenuItem);
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic(72);
        this.menuBar.add(jMenu3);
        this.aboutMenuItem = new JMenuItem("About", 65);
        jMenu3.add(this.aboutMenuItem);
        return this.menuBar;
    }

    protected JSplitPane setLayout(Editor editor) {
        int n = 0;
        this.categoryList = new JComboBox();
        this.dynTree = new DynamicTree(editor);
        this.currentCategory = new JComboBox();
        this.currentTitle = new JTextField();
        this.currentAccountName = new JTextField();
        this.currentPassword = new JPasswordField();
        this.currentDate = new JTextField();
        this.currentDate.setEnabled(false);
        this.currentNotes = new JTextArea();
        this.currentPasswordShow = new JCheckBox("Hide Passwords?", true);
        this.btnLock = new JButton("Lock");
        this.newEntry = new JButton("New Entry");
        this.saveEntry = new JButton("Save");
        this.delEntry = new JButton("Delete");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this.categoryList, gridBagConstraints);
        jPanel.add(this.categoryList);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.dynTree, gridBagConstraints);
        jPanel.add(this.dynTree);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel("Category: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout2.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this.currentCategory, gridBagConstraints);
        jPanel2.add(this.currentCategory);
        JLabel jLabel2 = new JLabel("Title: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout2.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this.currentTitle, gridBagConstraints);
        jPanel2.add(this.currentTitle);
        JLabel jLabel3 = new JLabel("Account: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout2.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this.currentAccountName, gridBagConstraints);
        jPanel2.add(this.currentAccountName);
        JLabel jLabel4 = new JLabel("    Password: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout2.setConstraints(jLabel4, gridBagConstraints);
        jPanel2.add(jLabel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this.currentPassword, gridBagConstraints);
        jPanel2.add(this.currentPassword);
        JLabel jLabel5 = new JLabel("Date: ");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout2.setConstraints(jLabel5, gridBagConstraints);
        jPanel2.add(jLabel5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(this.currentDate, gridBagConstraints);
        jPanel2.add(this.currentDate);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.currentNotes);
        gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout2.setConstraints(this.saveEntry, gridBagConstraints);
        jPanel2.add(this.saveEntry);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(this.newEntry);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(this.delEntry);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(this.btnLock);
        jPanel3.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel3.add(this.currentPasswordShow);
        JSplitPane jSplitPane = new JSplitPane(0, jPanel2, jPanel3);
        jSplitPane.setResizeWeight(1.0);
        JSplitPane jSplitPane2 = new JSplitPane(1, jPanel, jSplitPane);
        jSplitPane2.setResizeWeight(0.33);
        jPanel.setMinimumSize(new Dimension(200, 440));
        jPanel2.setMinimumSize(new Dimension(300, 400));
        jPanel3.setMinimumSize(new Dimension(300, 40));
        jPanel.setPreferredSize(new Dimension(150, 340));
        jPanel2.setPreferredSize(new Dimension(450, 300));
        jPanel3.setPreferredSize(new Dimension(450, 40));
        return jSplitPane2;
    }

    protected class PasswordTimeoutWorker
    implements Runnable {
        private Editor editor;
        private Date endDate = null;
        private Object sleepGate = new Object();

        public PasswordTimeoutWorker(Editor editor) {
            this.editor = editor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void restartTimeout() {
            this.endDate = new Date(new Date().getTime() + PASSWORD_TIMEOUT);
            Object object = this.sleepGate;
            synchronized (object) {
                this.sleepGate.notifyAll();
            }
        }

        public synchronized void setTimeout() {
            this.endDate = null;
        }

        public synchronized Date getEndDate() {
            return this.endDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object object;
                if (this.endDate != null) {
                    object = new Date();
                    long l = this.endDate.getTime() - ((Date)object).getTime();
                    if (l <= 0L) {
                        this.endDate = null;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    object = this.sleepGate;
                    synchronized (object) {
                        this.sleepGate.wait();
                        continue;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

