/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class Editor
extends Gui {
    protected char SEPARATOR = (char)47;
    private File previousDirectory = null;
    private String pdbFilename = "dummy.pdb";
    private Gui gui;
    private Model model;
    private JFrame frame;
    private Gui.PasswordTimeoutWorker timeoutThread;
    private int filterCategory = -1;
    private boolean textFieldChanged = true;
    private boolean showPassword = false;
    private boolean locked = false;

    public static void main(String[] stringArray) {
        String string = null;
        Editor editor = new Editor();
        editor.frame = new JFrame("KeyringEditor");
        editor.frame.setDefaultCloseOperation(3);
        if (stringArray.length > 1) {
            System.out.println("Usage: java -jar KeyringEditor.jar [keyring-database]");
            return;
        }
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        try {
            editor.setupGui(string);
        }
        catch (Exception exception) {
            editor.msgError(exception, "main", true);
        }
    }

    public String getFilename() {
        return this.pdbFilename;
    }

    public char getSeparator() {
        return this.SEPARATOR;
    }

    public Model getModel() {
        return this.model;
    }

    private boolean checkFile(String string) {
        int n;
        boolean bl = true;
        File file = new File(string);
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.frame, "File already exists. Continue?", "Warning", 0)) == 1) {
            bl = false;
        }
        return bl;
    }

    private void msgError(Exception exception, String string, boolean bl) {
        JOptionPane.showMessageDialog(this.frame, string + ": " + exception.getMessage(), "Error", 0);
        if (bl) {
            exception.printStackTrace(System.err);
        }
    }

    private void msgInformation(String string) {
        JOptionPane.showMessageDialog(this.frame, string, "Information", 1);
    }

    private void setupGui(String string) throws Exception {
        JMenuBar jMenuBar = this.setMenuBar();
        this.frame.setJMenuBar(jMenuBar);
        JSplitPane jSplitPane = this.setLayout(this);
        this.frame.setContentPane(jSplitPane);
        this.openMenuItem.addActionListener(new OpenListener(this));
        this.closeMenuItem.addActionListener(new CloseListener(this));
        this.quitMenuItem.addActionListener(new QuitListener(this));
        this.categoriesMenuItem.addActionListener(new editCategoriesListener(this));
        this.csvMenuItem.addActionListener(new csvListener(this));
        this.aboutMenuItem.addActionListener(new AboutListener(this));
        this.convertMenuItem.addActionListener(new convertListener(this));
        this.newMenuItem.addActionListener(new newListener(this));
        this.currentCategory.addActionListener(new currentCategorySelectionListener(this));
        this.currentTitle.getDocument().addDocumentListener(new documentListener(this));
        this.currentAccountName.getDocument().addDocumentListener(new documentListener(this));
        this.currentPassword.getDocument().addDocumentListener(new documentListener(this));
        this.currentNotes.getDocument().addDocumentListener(new documentListener(this));
        this.categoryList.addActionListener(new CategorySelectionListener(this));
        this.dynTree.getTree().addTreeSelectionListener(new treeSelectionListener(this));
        this.newEntry.addActionListener(new newEntryListener(this));
        this.saveEntry.addActionListener(new saveEntryListener(this));
        this.delEntry.addActionListener(new delEntryListener(this));
        this.btnLock.addActionListener(new PasswordLockListener(this));
        this.currentPasswordShow.addActionListener(new PasswordShowListener(this));
        this.frame.pack();
        this.frame.setVisible(true);
        this.timeoutThread = new Gui.PasswordTimeoutWorker(this, this);
        new Thread(this.timeoutThread).start();
        this.loadDatabase(string);
    }

    private void loadDatabase(String string) throws Exception {
        String[] stringArray = new String[]{"TripleDES", "TripleDES", "AES128", "AES256"};
        if (string != null) {
            this.model = new Model();
            try {
                this.model.loadData(string);
                this.pdbFilename = string;
                this.setupProperties(this.model.getElements());
            }
            catch (Exception exception) {
                this.msgError(exception, "Open keyring database", false);
                try {
                    this.loadDatabase(null);
                    return;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (!this.checkPassword()) {
                this.loadDatabase(null);
                return;
            }
            this.frame.setTitle("KeyringEditor: " + string + " (" + stringArray[this.model.crypto.type] + " | Database format " + this.model.pdbVersion + ")");
            this.setupCategories(this.model.getCategories());
            this.setMenuBar(false);
            this.enableButtons(true);
            this.setBtnLock(false, true);
            this.dynTree.populate();
        } else {
            this.model = null;
            this.frame.setTitle("KeyringEditor");
            this.setupCategories(null);
            this.setMenuBar(true);
            this.enableButtons(false);
            this.setBtnLock(false, false);
            this.dynTree.clear();
        }
    }

    private void setupProperties(Enumeration enumeration) {
        Prop prop = new Prop(this);
        prop.setup();
        Enumeration enumeration2 = enumeration;
        while (enumeration2.hasMoreElements()) {
            Entry entry = (Entry)enumeration2.nextElement();
            entry.setTitleSeparator(this.SEPARATOR);
        }
    }

    private void setMenuBar(boolean bl) {
        this.openMenuItem.setEnabled(bl);
        this.closeMenuItem.setEnabled(!bl);
        this.csvMenuItem.setEnabled(!bl);
        this.categoriesMenuItem.setEnabled(!bl);
        this.convertMenuItem.setEnabled(!bl);
    }

    private void enableButtons(boolean bl) {
        this.delEntry.setEnabled(false);
        this.saveEntry.setEnabled(false);
        this.newEntry.setEnabled(bl);
        this.enableFields(bl);
    }

    private void enableFields(boolean bl) {
        this.currentCategory.setEditable(false);
        this.currentTitle.setEditable(bl);
        this.currentAccountName.setEditable(bl);
        this.currentPassword.setEditable(bl);
        this.currentNotes.setEditable(bl);
    }

    private void setBtnLock(boolean bl, boolean bl2) {
        this.btnLock.setText(bl ? "Unlock" : "Lock");
        this.btnLock.setEnabled(bl2);
        this.locked = bl;
        this.saveEntry.setBackground(null);
    }

    private void setupCategories(Vector vector) {
        Vector<String> vector2 = vector != null ? (Vector<String>)vector.clone() : new Vector<String>();
        vector2.add(0, "All");
        this.categoryList.setModel(new DefaultComboBoxModel(vector2));
        Vector vector3 = vector != null ? (Vector)vector.clone() : new Vector();
        this.currentCategory.setModel(new DefaultComboBoxModel(vector3));
    }

    private boolean checkPassword() {
        try {
            this.model.crypto.setPassword(this.getPasswordDialog());
            this.timeoutThread.restartTimeout();
            return true;
        }
        catch (Exception exception) {
            this.msgError(exception, "checkPassword", false);
            this.timeoutThread.setTimeout();
            return false;
        }
    }

    private char[] getPasswordDialog() throws Exception {
        PasswordDialog passwordDialog = new PasswordDialog(this.frame);
        passwordDialog.pack();
        passwordDialog.setVisible(true);
        return passwordDialog.getPassword();
    }

    private void showEntry() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.dynTree.getLastNode();
        if (this.locked) {
            return;
        }
        try {
            Date date = this.timeoutThread.getEndDate();
            if (date == null) {
                this.clearEntry();
                this.setBtnLock(true, true);
                this.enableButtons(false);
                this.saveEntry.setBackground(null);
                return;
            }
            this.timeoutThread.restartTimeout();
            if (defaultMutableTreeNode == null || !defaultMutableTreeNode.isLeaf() || defaultMutableTreeNode.isRoot()) {
                this.clearEntry();
                this.saveEntry.setEnabled(false);
                this.saveEntry.setBackground(null);
                this.delEntry.setEnabled(false);
                return;
            }
            Object object = defaultMutableTreeNode.getUserObject();
            Entry entry = (Entry)object;
            if (this.currentCategory.getItemCount() > entry.getCategory()) {
                this.currentCategory.setSelectedIndex(entry.getCategory());
            } else {
                this.currentCategory.setSelectedIndex(0);
            }
            this.currentTitle.setText(entry.getTitle());
            this.currentAccountName.setText(entry.getAccount());
            this.currentNotes.setText(entry.getNotes());
            this.currentPassword.setText(entry.getPassword());
            this.currentDate.setText(entry.getDate());
            this.textFieldChanged = false;
            this.saveEntry.setEnabled(false);
            this.saveEntry.setBackground(null);
            this.delEntry.setEnabled(true);
        }
        catch (Exception exception) {
            this.msgError(exception, "showEntry", true);
            try {
                this.loadDatabase(null);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    private void clearEntry() {
        this.currentTitle.setText("");
        this.currentAccountName.setText("");
        this.currentPassword.setText("");
        this.currentNotes.setText("");
        this.currentDate.setText("");
    }

    public class PasswordLockListener
    implements ActionListener {
        protected Editor editor;

        protected PasswordLockListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.editor.locked) {
                this.editor.setBtnLock(true, true);
                this.editor.enableButtons(false);
                this.editor.clearEntry();
            } else if (this.editor.checkPassword()) {
                this.editor.setBtnLock(false, true);
                this.editor.enableButtons(true);
                this.editor.showEntry();
            }
        }
    }

    public class PasswordShowListener
    implements ActionListener {
        protected Editor editor;

        protected PasswordShowListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!Editor.this.showPassword) {
                Editor.this.showPassword = true;
                this.editor.currentPassword.setEchoChar('\u0000');
            } else {
                Editor.this.showPassword = false;
                this.editor.currentPassword.setEchoChar('*');
            }
        }
    }

    public class currentCategorySelectionListener
    implements ActionListener {
        protected Editor editor;

        public currentCategorySelectionListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.editor.textFieldChanged && !this.editor.locked) {
                this.editor.textFieldChanged = true;
                this.editor.saveEntry.setEnabled(true);
                this.editor.saveEntry.setBackground(Color.YELLOW);
            }
        }
    }

    public class CategorySelectionListener
    implements ActionListener {
        protected Editor editor;

        public CategorySelectionListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.editor.dynTree.setCategoryFilter(this.editor.categoryList.getSelectedIndex());
            this.editor.showEntry();
        }
    }

    public class treeSelectionListener
    implements TreeSelectionListener {
        protected Editor editor;

        protected treeSelectionListener(Editor editor2) {
            this.editor = editor2;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            this.editor.showEntry();
        }
    }

    public class documentListener
    implements DocumentListener {
        protected Editor editor;

        protected documentListener(Editor editor2) {
            this.editor = editor2;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateLog(documentEvent, "insert");
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateLog(documentEvent, "remove");
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateLog(documentEvent, "changed");
        }

        public void updateLog(DocumentEvent documentEvent, String string) {
            if (!this.editor.textFieldChanged && !this.editor.locked) {
                this.editor.textFieldChanged = true;
                this.editor.saveEntry.setEnabled(true);
                this.editor.saveEntry.setBackground(Color.YELLOW);
            }
        }
    }

    public class delEntryListener
    implements ActionListener {
        protected Editor editor;

        public delEntryListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.editor.dynTree.getLastNode();
            if (defaultMutableTreeNode != null) {
                Entry entry = this.editor.dynTree.getEntry(defaultMutableTreeNode);
                this.editor.model.removeEntry(entry);
                this.editor.dynTree.populate();
                try {
                    this.editor.model.saveData(Editor.this.pdbFilename);
                    Editor.this.msgInformation("Entry " + entry.getEntryId() + " deleted. Database " + this.editor.pdbFilename + " updated.");
                }
                catch (Exception exception) {
                    Editor.this.msgError(exception, "delEntryListener", false);
                }
            }
        }
    }

    public class saveEntryListener
    implements ActionListener {
        protected Editor editor;

        public saveEntryListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.editor.dynTree.getLastNode();
            byte[] byArray = null;
            int n = 0;
            int n2 = 8;
            try {
                if (defaultMutableTreeNode != null) {
                    Entry entry = this.editor.dynTree.getEntry(defaultMutableTreeNode);
                    char[] cArray = this.editor.currentPassword.getPassword();
                    switch (((Editor)Editor.this).model.pdbVersion) {
                        case 4: {
                            byArray = Model.toRecordFormat4(this.editor.currentAccountName.getText() + "\u0000" + new String(cArray) + "\u0000" + this.editor.currentNotes.getText() + "\u0000");
                            break;
                        }
                        case 5: {
                            byArray = Model.toRecordFormat5(this.editor.currentAccountName.getText(), new String(cArray), this.editor.currentNotes.getText());
                            if (((Editor)Editor.this).model.crypto.type == 1) break;
                            n2 = 16;
                        }
                    }
                    byte[] byArray2 = ((Editor)this.editor).model.crypto.encrypt(byArray);
                    int n3 = this.editor.currentTitle.getText().length() + byArray2.length - 16;
                    switch (((Editor)Editor.this).model.pdbVersion) {
                        case 4: {
                            n = n3 + 1;
                            break;
                        }
                        case 5: {
                            n = n3 + 4 + n3 % 2 + n2;
                        }
                    }
                    entry.title = this.editor.currentTitle.getText();
                    entry.encrypted = Model.sliceBytes(byArray2, 16, byArray2.length - 16);
                    entry.category = this.editor.currentCategory.getSelectedIndex();
                    entry.attribute = this.editor.currentCategory.getSelectedIndex() | 0x40;
                    entry.recordLength = n;
                    entry.iv = Model.sliceBytes(byArray2, 0, n2);
                    this.editor.dynTree.populate();
                    this.editor.model.saveData(Editor.this.pdbFilename);
                    Editor.this.msgInformation("Entries saved to: " + this.editor.pdbFilename);
                }
            }
            catch (Exception exception) {
                Editor.this.msgError(exception, "saveEntryListener", true);
            }
        }
    }

    public class newEntryListener
    implements ActionListener {
        protected Editor editor;

        protected newEntryListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditDialog editDialog = new EditDialog((Frame)this.editor.frame, this.editor.model.getCategories());
            editDialog.pack();
            editDialog.setVisible(true);
            Object[] objectArray = editDialog.getNewEntry();
            byte[] byArray = null;
            int n = 0;
            int n2 = this.editor.model.getEntriesSize() + 1;
            int n3 = 8;
            try {
                if (objectArray[0] != null) {
                    switch (((Editor)Editor.this).model.pdbVersion) {
                        case 4: {
                            byArray = Model.toRecordFormat4((String)objectArray[2] + "\u0000" + (String)objectArray[3] + "\u0000" + (String)objectArray[4] + "\u0000");
                            break;
                        }
                        case 5: {
                            byArray = Model.toRecordFormat5((String)objectArray[2], (String)objectArray[3], (String)objectArray[4]);
                            if (((Editor)Editor.this).model.crypto.type == 1) break;
                            n3 = 16;
                        }
                    }
                    byte[] byArray2 = ((Editor)this.editor).model.crypto.encrypt(byArray);
                    int n4 = ((String)objectArray[1]).length() + byArray2.length - 16;
                    switch (((Editor)Editor.this).model.pdbVersion) {
                        case 4: {
                            n = n4 + 1;
                            break;
                        }
                        case 5: {
                            n = n4 + 4 + n4 % 2 + n3;
                        }
                    }
                    int n5 = this.editor.model.getNewUniqueId();
                    Entry entry = new Entry(n2, (String)objectArray[1], (Integer)objectArray[0], Model.sliceBytes(byArray2, 16, byArray2.length - 16), ((Editor)this.editor).model.crypto, (int)((Integer)objectArray[0] | 0x40), n5, n, Model.sliceBytes(byArray2, 0, n3));
                    this.editor.model.addEntry(entry);
                    this.editor.dynTree.populate();
                    this.editor.model.saveData(Editor.this.pdbFilename);
                    this.editor.dynTree.show(entry);
                }
            }
            catch (Exception exception) {
                Editor.this.msgError(exception, "newEntryListener", true);
            }
        }
    }

    public class AboutListener
    implements ActionListener {
        protected Editor editor;

        protected AboutListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = this.editor.frame;
            StringBuffer stringBuffer = new StringBuffer();
            Editor.this.gui;
            JOptionPane.showMessageDialog(jFrame, stringBuffer.append("KeyringEditor").append(" ").append("v").append("1.1").append("\n\nCopyright 2005 Markus Griessnig\n").append("Vienna University of Technology\n").append("Institute of Computer Technology\n\n").append("KeyringEditor is based on:\n").append("Java Keyring v0.6\n").append("Copyright 2004 Frank Taylor <keyring@lieder.me.uk>\n\n").append("These programs are distributed in the hope that they will be useful,\n").append("but WITHOUT ANY WARRANTY; without even the implied warranty of\n").append("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n").append("See the GNU General Public License for more details.\n").toString(), "About", 1);
        }
    }

    public class newListener
    implements ActionListener {
        protected Editor editor;

        protected newListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Editor.this.locked) {
                Editor.this.msgInformation("Unlock application first.");
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Generate new minimal database");
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setCurrentDirectory(Editor.this.previousDirectory);
            int n = jFileChooser.showSaveDialog(this.editor.frame);
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    Editor.this.previousDirectory = file.getParentFile();
                    String string = file.getCanonicalPath();
                    boolean bl = Editor.this.checkFile(string);
                    if (bl) {
                        Editor.this.model;
                        Model.writeNewDatabase(string);
                        Editor.this.msgInformation("New minimal database with password 'test' generated.");
                    }
                }
                catch (Exception exception) {
                    Editor.this.msgError(exception, "Could not generate file " + Editor.this.model.getCsvFilename(), false);
                }
            }
        }
    }

    public class convertListener
    implements ActionListener {
        protected Editor editor;

        protected convertListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Editor.this.locked) {
                Editor.this.msgInformation("Unlock application first.");
                return;
            }
            ConvertDialog convertDialog = new ConvertDialog((Frame)this.editor.frame, this.editor.model, ((Editor)this.editor).model.pdbVersion);
            convertDialog.pack();
            convertDialog.setVisible(true);
            if (!convertDialog.getCancelled()) {
                Editor.this.msgInformation("Database converted.");
                try {
                    this.editor.loadDatabase(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class csvListener
    implements ActionListener {
        protected Editor editor;

        protected csvListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Editor.this.locked) {
                Editor.this.msgInformation("Unlock application first.");
                return;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Save Keyring database to CSV-File");
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setCurrentDirectory(Editor.this.previousDirectory);
            int n = jFileChooser.showSaveDialog(this.editor.frame);
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    Editor.this.previousDirectory = file.getParentFile();
                    String string = file.getCanonicalPath();
                    boolean bl = Editor.this.checkFile(string);
                    if (bl) {
                        this.editor.model.saveEntriesToFile(string);
                        Editor.this.msgInformation("Entries saved to: " + Editor.this.model.getCsvFilename());
                    }
                }
                catch (Exception exception) {
                    Editor.this.msgError(exception, "Could not save entries to " + Editor.this.model.getCsvFilename(), false);
                }
            }
        }
    }

    public class editCategoriesListener
    implements ActionListener {
        protected Editor editor;

        protected editCategoriesListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (Editor.this.locked) {
                Editor.this.msgInformation("Unlock application first.");
                return;
            }
            CategoriesDialog categoriesDialog = new CategoriesDialog((Frame)Editor.this.frame, Editor.this.model.getCategories());
            categoriesDialog.pack();
            categoriesDialog.setVisible(true);
            Vector vector = categoriesDialog.getNewCategories();
            if (vector != null) {
                Editor.this.setupCategories(vector);
                Editor.this.model.setCategories(vector);
                try {
                    this.editor.model.saveData(Editor.this.pdbFilename);
                }
                catch (Exception exception) {
                    Editor.this.msgError(exception, "Could not save entries to " + Editor.this.pdbFilename, false);
                }
            }
        }
    }

    public class QuitListener
    implements ActionListener {
        protected Editor editor;

        protected QuitListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    public class CloseListener
    implements ActionListener {
        protected Editor editor;

        protected CloseListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                this.editor.loadDatabase(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class OpenListener
    implements ActionListener {
        protected Editor editor;

        protected OpenListener(Editor editor2) {
            this.editor = editor2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Open Keyring database");
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setCurrentDirectory(Editor.this.previousDirectory);
            int n = jFileChooser.showOpenDialog(this.editor.frame);
            if (n == 0) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    Editor.this.previousDirectory = file.getParentFile();
                    Editor.this.pdbFilename = file.getCanonicalPath();
                    this.editor.loadDatabase(Editor.this.pdbFilename);
                }
                catch (Exception exception) {
                    Editor.this.msgError(exception, "Open Keyring database", false);
                    try {
                        this.editor.loadDatabase(null);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

