/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DynamicTree
extends JPanel {
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private JTree tree;
    private Editor editor;
    private int filterCategory = 0;

    public DynamicTree(Editor editor) {
        super(new GridLayout(1, 0));
        this.editor = editor;
        this.rootNode = new DefaultMutableTreeNode("");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
    }

    public void show(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode == null || !defaultMutableTreeNode.isLeaf()) continue;
            Object object2 = defaultMutableTreeNode.getUserObject();
            Entry entry = (Entry)object2;
            Entry entry2 = (Entry)object;
            if (entry.getEntryId() != entry2.getEntryId()) continue;
            this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public boolean setCategoryFilter(int n) {
        boolean bl = n != this.filterCategory;
        this.filterCategory = n;
        this.populate();
        return bl;
    }

    public void clearFilter() {
        this.filterCategory = 0;
        this.populate();
    }

    public Entry getEntry(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object = defaultMutableTreeNode.getUserObject();
        return (Entry)object;
    }

    public DefaultMutableTreeNode getLastNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode != null && defaultMutableTreeNode.isLeaf()) {
            return defaultMutableTreeNode;
        }
        return null;
    }

    public void reload() {
        this.treeModel.reload();
    }

    public void clear() {
        this.rootNode.setUserObject("");
        this.rootNode.removeAllChildren();
        this.treeModel.reload();
    }

    public void removeCurrentNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        MutableTreeNode mutableTreeNode;
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null && (mutableTreeNode = (MutableTreeNode)(defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getParent()) != null) {
            this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
            return;
        }
    }

    public void populate() {
        this.clear();
        this.rootNode.setUserObject(this.editor.getFilename());
        Model model = this.editor.getModel();
        if (model == null) {
            return;
        }
        Vector vector = (Vector)model.getEntries().clone();
        Collections.sort(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n;
            Entry entry = (Entry)enumeration.nextElement();
            if (this.filterCategory != 0 && this.filterCategory - 1 != entry.getCategory()) continue;
            int n2 = 0;
            DefaultMutableTreeNode defaultMutableTreeNode = this.rootNode;
            String string = entry.getTitle();
            while ((n = string.indexOf(this.editor.getSeparator(), n2)) != -1) {
                String string2 = string.substring(n2, n);
                String string3 = string.substring(n + 1, string.length());
                n2 = n + 1;
                DefaultMutableTreeNode defaultMutableTreeNode2 = DynamicTree.searchForBranchNode(defaultMutableTreeNode, string2);
                if (defaultMutableTreeNode2 == null) {
                    Dummy dummy = new Dummy(string2);
                    defaultMutableTreeNode2 = this.addObject(defaultMutableTreeNode, dummy, true);
                }
                defaultMutableTreeNode = defaultMutableTreeNode2;
            }
            this.addObject(defaultMutableTreeNode, entry, true);
        }
    }

    public DefaultMutableTreeNode addObject(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object);
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.rootNode;
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (bl) {
            this.tree.scrollPathToVisible(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        return defaultMutableTreeNode2;
    }

    private static DefaultMutableTreeNode searchForBranchNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)enumeration.nextElement();
            try {
                Dummy dummy = (Dummy)defaultMutableTreeNode2.getUserObject();
                if (!string.equals(dummy.toString())) continue;
                return defaultMutableTreeNode2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static class Dummy {
        String title;

        public Dummy(String string) {
            this.title = string;
        }

        public String toString() {
            return this.title;
        }
    }
}

