/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;

public class ConvertDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private Frame frame;
    private JComboBox cboCipher;
    private JComboBox cboIter;
    private JPasswordField password;
    private Vector cipher;
    private Vector iter;
    private Model model;
    private int fromFormat;
    private JOptionPane optionPane;
    private String btnString1 = "OK";
    private String btnString2 = "Cancel";
    private boolean cancelled = false;

    public ConvertDialog(Frame frame, Model model, int n) {
        super(frame, "Convert database", true);
        this.frame = frame;
        this.model = model;
        this.fromFormat = n;
        this.cipher = new Vector();
        this.cipher.add("TripleDES | Database format 4");
        this.cipher.add("TripleDES | Database format 5");
        this.cipher.add("AES128 | Database format 5");
        this.cipher.add("AES256 | Database format 5");
        this.cboCipher = new JComboBox(this.cipher);
        this.cboCipher.setModel(new DefaultComboBoxModel(this.cipher));
        this.iter = new Vector();
        this.iter.add(new Integer(50));
        this.iter.add(new Integer(250));
        this.iter.add(new Integer(500));
        this.iter.add(new Integer(1000));
        this.cboIter = new JComboBox(this.iter);
        this.cboIter.setModel(new DefaultComboBoxModel(this.iter));
        this.password = new JPasswordField(20);
        String string = "Cipher: ";
        String string2 = "Iterations: ";
        String string3 = "New password: ";
        Object[] objectArray = new Object[]{string, this.cboCipher, string2, this.cboIter, string3, this.password};
        Object[] objectArray2 = new Object[]{this.btnString1, this.btnString2};
        this.optionPane = new JOptionPane(objectArray, -1, 0, null, objectArray2, objectArray2[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConvertDialog.this.optionPane.setValue(new Integer(-1));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ConvertDialog.this.password.requestFocusInWindow();
            }
        });
        this.optionPane.addPropertyChangeListener(this);
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.isVisible() && propertyChangeEvent.getSource() == this.optionPane && ("value".equals(string) || "inputValue".equals(string))) {
            Object object = this.optionPane.getValue();
            if (object == JOptionPane.UNINITIALIZED_VALUE) {
                return;
            }
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            if (this.btnString1.equals(object)) {
                if (this.password.getPassword().length == 0) {
                    JOptionPane.showMessageDialog(this, "Sorry, password must not be empty!\n", "Error", 0);
                    this.cancelled = true;
                    this.password.requestFocusInWindow();
                    return;
                }
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Convert Keyring database");
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showSaveDialog(this.frame);
                if (n == 0) {
                    try {
                        File file = jFileChooser.getSelectedFile();
                        String string2 = file.getCanonicalPath();
                        int n2 = 0;
                        int n3 = this.cboCipher.getSelectedIndex();
                        switch (n3) {
                            case 0: {
                                n2 = 4;
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                n2 = 5;
                            }
                        }
                        this.model.convertDatabase(this.fromFormat, n2, string2, this.password.getPassword(), n3, (Integer)this.cboIter.getSelectedItem());
                    }
                    catch (Exception exception) {
                        this.cancelled = true;
                        JOptionPane.showMessageDialog(this.frame, "Convert database: " + exception.getMessage(), "Error", 0);
                        exception.printStackTrace(System.err);
                    }
                } else {
                    this.cancelled = true;
                }
            } else {
                this.cancelled = true;
            }
            this.clearAndHide();
        }
    }

    private void clearAndHide() {
        this.password.setText(null);
        this.setVisible(false);
    }
}

